/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms;

import javax.jms.ConnectionFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.jms.JmsAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.jms.JmsProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.jms.core.JmsMessagingTemplate;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;

@Configuration
@ConditionalOnClass(value={JmsTemplate.class})
@ConditionalOnBean(value={ConnectionFactory.class})
@EnableConfigurationProperties(value={JmsProperties.class})
@Import(value={JmsAnnotationDrivenConfiguration.class})
public class JmsAutoConfiguration {

    @ConditionalOnClass(value={JmsMessagingTemplate.class})
    @Import(value={JmsTemplateConfiguration.class})
    protected static class MessagingTemplateConfiguration {
        protected MessagingTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnSingleCandidate(value=JmsTemplate.class)
        public JmsMessagingTemplate jmsMessagingTemplate(JmsTemplate jmsTemplate) {
            return new JmsMessagingTemplate(jmsTemplate);
        }
    }

    @Configuration
    protected static class JmsTemplateConfiguration {
        private final JmsProperties properties;
        private final ObjectProvider<DestinationResolver> destinationResolver;
        private final ObjectProvider<MessageConverter> messageConverter;

        public JmsTemplateConfiguration(JmsProperties properties, ObjectProvider<DestinationResolver> destinationResolver, ObjectProvider<MessageConverter> messageConverter) {
            this.properties = properties;
            this.destinationResolver = destinationResolver;
            this.messageConverter = messageConverter;
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnSingleCandidate(value=ConnectionFactory.class)
        public JmsTemplate jmsTemplate(ConnectionFactory connectionFactory) {
            MessageConverter messageConverter;
            JmsTemplate jmsTemplate = new JmsTemplate(connectionFactory);
            jmsTemplate.setPubSubDomain(this.properties.isPubSubDomain());
            DestinationResolver destinationResolver = (DestinationResolver)this.destinationResolver.getIfUnique();
            if (destinationResolver != null) {
                jmsTemplate.setDestinationResolver(destinationResolver);
            }
            if ((messageConverter = (MessageConverter)this.messageConverter.getIfUnique()) != null) {
                jmsTemplate.setMessageConverter(messageConverter);
            }
            return jmsTemplate;
        }
    }
}

