/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

@Order(value=-2147483648)
class OnClassCondition
extends SpringBootCondition {
    OnClassCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap<String, Object> onMissingClasses;
        ConditionMessage matchMessage = ConditionMessage.empty();
        MultiValueMap<String, Object> onClasses = this.getAttributes(metadata, ConditionalOnClass.class);
        if (onClasses != null) {
            List<String> missing = this.getMatchingClasses(onClasses, MatchType.MISSING, context);
            if (!missing.isEmpty()) {
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnClass.class, new Object[0]).didNotFind("required class", "required classes").items(ConditionMessage.Style.QUOTE, missing));
            }
            matchMessage = matchMessage.andCondition(ConditionalOnClass.class, new Object[0]).found("required class", "required classes").items(ConditionMessage.Style.QUOTE, this.getMatchingClasses(onClasses, MatchType.PRESENT, context));
        }
        if ((onMissingClasses = this.getAttributes(metadata, ConditionalOnMissingClass.class)) != null) {
            List<String> present = this.getMatchingClasses(onMissingClasses, MatchType.PRESENT, context);
            if (!present.isEmpty()) {
                return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnMissingClass.class, new Object[0]).found("unwanted class", "unwanted classes").items(ConditionMessage.Style.QUOTE, present));
            }
            matchMessage = matchMessage.andCondition(ConditionalOnMissingClass.class, new Object[0]).didNotFind("unwanted class", "unwanted classes").items(ConditionMessage.Style.QUOTE, this.getMatchingClasses(onMissingClasses, MatchType.MISSING, context));
        }
        return ConditionOutcome.match(matchMessage);
    }

    private MultiValueMap<String, Object> getAttributes(AnnotatedTypeMetadata metadata, Class<?> annotationType) {
        return metadata.getAllAnnotationAttributes(annotationType.getName(), true);
    }

    private List<String> getMatchingClasses(MultiValueMap<String, Object> attributes, MatchType matchType, ConditionContext context) {
        LinkedList<String> matches = new LinkedList<String>();
        this.addAll(matches, (List)attributes.get((Object)"value"));
        this.addAll(matches, (List)attributes.get((Object)"name"));
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            if (matchType.matches((String)iterator.next(), context)) continue;
            iterator.remove();
        }
        return matches;
    }

    private void addAll(List<String> list, List<Object> itemsToAdd) {
        if (itemsToAdd != null) {
            for (Object item : itemsToAdd) {
                Collections.addAll(list, (String[])item);
            }
        }
    }

    private static enum MatchType {
        PRESENT{

            @Override
            public boolean matches(String className, ConditionContext context) {
                return ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader());
            }
        }
        ,
        MISSING{

            @Override
            public boolean matches(String className, ConditionContext context) {
                return !ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader());
            }
        };


        public abstract boolean matches(String var1, ConditionContext var2);
    }
}

