/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class JspTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    @Override
    public boolean isTemplateAvailable(String view, Environment environment, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent((String)"org.apache.jasper.compiler.JspConfig", (ClassLoader)classLoader)) {
            String prefix = this.getProperty(environment, "spring.mvc.view.prefix", "spring.view.prefix", WebMvcAutoConfiguration.DEFAULT_PREFIX);
            String suffix = this.getProperty(environment, "spring.mvc.view.suffix", "spring.view.suffix", WebMvcAutoConfiguration.DEFAULT_SUFFIX);
            return resourceLoader.getResource(prefix + view + suffix).exists();
        }
        return false;
    }

    private String getProperty(Environment environment, String key, String deprecatedKey, String defaultValue) {
        if (environment.containsProperty(key)) {
            return environment.getProperty(key);
        }
        return environment.getProperty(deprecatedKey, defaultValue);
    }
}

