/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class FixedAuthoritiesExtractor
implements AuthoritiesExtractor {
    private static final String AUTHORITIES = "authorities";

    @Override
    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        String authorities = "ROLE_USER";
        if (map.containsKey(AUTHORITIES)) {
            authorities = this.asAuthorities(map.get(AUTHORITIES));
        }
        return AuthorityUtils.commaSeparatedStringToAuthorityList((String)authorities);
    }

    private String asAuthorities(Object object) {
        if (object instanceof Collection) {
            return StringUtils.collectionToCommaDelimitedString((Collection)((Collection)object));
        }
        if (ObjectUtils.isArray((Object)object)) {
            return StringUtils.arrayToCommaDelimitedString((Object[])((Object[])object));
        }
        return object.toString();
    }
}

