/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mail;

import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.javamail.JavaMailSenderImpl;

@Configuration
@AutoConfigureAfter(value={MailSenderAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.mail", value={"test-connection"})
@ConditionalOnSingleCandidate(value=JavaMailSenderImpl.class)
public class MailSenderValidatorAutoConfiguration {
    @Autowired
    private JavaMailSenderImpl mailSender;

    @PostConstruct
    public void validateConnection() {
        try {
            this.mailSender.testConnection();
        }
        catch (MessagingException ex) {
            throw new IllegalStateException("Mail server is not available", ex);
        }
    }
}

