/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

abstract class AbstractNestedCondition
extends SpringBootCondition
implements ConfigurationCondition {
    private final ConfigurationCondition.ConfigurationPhase configurationPhase;

    AbstractNestedCondition(ConfigurationCondition.ConfigurationPhase configurationPhase) {
        Assert.notNull((Object)configurationPhase, (String)"ConfigurationPhase must not be null");
        this.configurationPhase = configurationPhase;
    }

    public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
        return this.configurationPhase;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String className = this.getClass().getName();
        MemberConditions memberConditions = new MemberConditions(context, className);
        MemberMatchOutcomes memberOutcomes = new MemberMatchOutcomes(memberConditions);
        return this.getFinalMatchOutcome(memberOutcomes);
    }

    protected abstract ConditionOutcome getFinalMatchOutcome(MemberMatchOutcomes var1);

    private static class MemberConditions {
        private final ConditionContext context;
        private final MetadataReaderFactory readerFactory;
        private final Map<AnnotationMetadata, List<Condition>> memberConditions;

        MemberConditions(ConditionContext context, String className) {
            this.context = context;
            this.readerFactory = new SimpleMetadataReaderFactory(context.getResourceLoader());
            String[] members = this.getMetadata(className).getMemberClassNames();
            this.memberConditions = this.getMemberConditions(members);
        }

        private Map<AnnotationMetadata, List<Condition>> getMemberConditions(String[] members) {
            LinkedMultiValueMap memberConditions = new LinkedMultiValueMap();
            for (String member : members) {
                AnnotationMetadata metadata = this.getMetadata(member);
                for (String[] conditionClasses : this.getConditionClasses((AnnotatedTypeMetadata)metadata)) {
                    for (String conditionClass : conditionClasses) {
                        Condition condition = this.getCondition(conditionClass);
                        memberConditions.add((Object)metadata, (Object)condition);
                    }
                }
            }
            return Collections.unmodifiableMap(memberConditions);
        }

        private AnnotationMetadata getMetadata(String className) {
            try {
                return this.readerFactory.getMetadataReader(className).getAnnotationMetadata();
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private List<String[]> getConditionClasses(AnnotatedTypeMetadata metadata) {
            MultiValueMap attributes = metadata.getAllAnnotationAttributes(Conditional.class.getName(), true);
            List<String[]> values = attributes != null ? (List<String[]>)attributes.get((Object)"value") : null;
            return values != null ? values : Collections.emptyList();
        }

        private Condition getCondition(String conditionClassName) {
            Class conditionClass = ClassUtils.resolveClassName((String)conditionClassName, (ClassLoader)this.context.getClassLoader());
            return (Condition)BeanUtils.instantiateClass((Class)conditionClass);
        }

        public List<ConditionOutcome> getMatchOutcomes() {
            ArrayList<ConditionOutcome> outcomes = new ArrayList<ConditionOutcome>();
            for (Map.Entry<AnnotationMetadata, List<Condition>> entry : this.memberConditions.entrySet()) {
                AnnotationMetadata metadata = entry.getKey();
                for (Condition condition : entry.getValue()) {
                    outcomes.add(this.getConditionOutcome(metadata, condition));
                }
            }
            return Collections.unmodifiableList(outcomes);
        }

        private ConditionOutcome getConditionOutcome(AnnotationMetadata metadata, Condition condition) {
            String messagePrefix = "member condition on " + metadata.getClassName();
            if (condition instanceof SpringBootCondition) {
                ConditionOutcome outcome = ((SpringBootCondition)condition).getMatchOutcome(this.context, (AnnotatedTypeMetadata)metadata);
                String message = outcome.getMessage();
                return new ConditionOutcome(outcome.isMatch(), messagePrefix + (StringUtils.hasLength((String)message) ? " : " + message : ""));
            }
            boolean matches = condition.matches(this.context, (AnnotatedTypeMetadata)metadata);
            return new ConditionOutcome(matches, messagePrefix);
        }
    }

    protected static class MemberMatchOutcomes {
        private final List<ConditionOutcome> all;
        private final List<ConditionOutcome> matches;
        private final List<ConditionOutcome> nonMatches;

        public MemberMatchOutcomes(MemberConditions memberConditions) {
            this.all = Collections.unmodifiableList(memberConditions.getMatchOutcomes());
            ArrayList<ConditionOutcome> matches = new ArrayList<ConditionOutcome>();
            ArrayList nonMatches = new ArrayList();
            for (ConditionOutcome outcome : this.all) {
                (outcome.isMatch() ? matches : nonMatches).add(outcome);
            }
            this.matches = Collections.unmodifiableList(matches);
            this.nonMatches = Collections.unmodifiableList(nonMatches);
        }

        public List<ConditionOutcome> getAll() {
            return this.all;
        }

        public List<ConditionOutcome> getMatches() {
            return this.matches;
        }

        public List<ConditionOutcome> getNonMatches() {
            return this.nonMatches;
        }
    }
}

