/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.config.AbstractMessageBrokerConfiguration;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@ConditionalOnWebApplication
@ConditionalOnClass(value={WebSocketMessageBrokerConfigurer.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class WebSocketMessagingAutoConfiguration {

    @Configuration
    @ConditionalOnBean(value={DelegatingWebSocketMessageBrokerConfiguration.class, ObjectMapper.class})
    @ConditionalOnClass(value={ObjectMapper.class, AbstractMessageBrokerConfiguration.class})
    static class WebSocketMessageConverterConfiguration
    extends AbstractWebSocketMessageBrokerConfigurer {
        @Autowired
        private ObjectMapper objectMapper;

        WebSocketMessageConverterConfiguration() {
        }

        public void registerStompEndpoints(StompEndpointRegistry registry) {
        }

        public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
            MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
            converter.setObjectMapper(this.objectMapper);
            DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
            resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
            converter.setContentTypeResolver((ContentTypeResolver)resolver);
            messageConverters.add((MessageConverter)converter);
            return true;
        }
    }
}

