/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import java.util.LinkedHashSet;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.rabbitmq")
public class RabbitProperties {
    private String host = "localhost";
    private int port = 5672;
    private String username;
    private String password;
    private final Ssl ssl = new Ssl();
    private String virtualHost;
    private String addresses;
    private Integer requestedHeartbeat;
    private final Listener listener = new Listener();

    public String getHost() {
        if (this.addresses == null) {
            return this.host;
        }
        String[] hosts = StringUtils.delimitedListToStringArray((String)this.addresses, (String)":");
        if (hosts.length == 2) {
            return hosts[0];
        }
        return null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        if (this.addresses == null) {
            return this.port;
        }
        String[] hosts = StringUtils.delimitedListToStringArray((String)this.addresses, (String)":");
        if (hosts.length >= 2) {
            return Integer.valueOf(StringUtils.commaDelimitedListToStringArray((String)hosts[1])[0]);
        }
        return this.port;
    }

    public void setAddresses(String addresses) {
        this.addresses = this.parseAddresses(addresses);
    }

    public String getAddresses() {
        return this.addresses == null ? this.host + ":" + this.port : this.addresses;
    }

    private String parseAddresses(String addresses) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String address : StringUtils.commaDelimitedListToStringArray((String)addresses)) {
            int index;
            if ((address = address.trim()).startsWith("amqp://")) {
                address = address.substring("amqp://".length());
            }
            if (address.contains("@")) {
                String[] split = StringUtils.split((String)address, (String)"@");
                String creds = split[0];
                address = split[1];
                split = StringUtils.split((String)creds, (String)":");
                this.username = split[0];
                if (split.length > 0) {
                    this.password = split[1];
                }
            }
            if ((index = address.indexOf("/")) >= 0 && index < address.length()) {
                this.setVirtualHost(address.substring(index + 1));
                address = address.substring(0, index);
            }
            if (!address.contains(":")) {
                address = address + ":" + this.port;
            }
            result.add(address);
        }
        return result.isEmpty() ? null : StringUtils.collectionToCommaDelimitedString(result);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = "".equals(virtualHost) ? "/" : virtualHost;
    }

    public Integer getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setRequestedHeartbeat(Integer requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public Listener getListener() {
        return this.listener;
    }

    public static class Listener {
        private boolean autoStartup = true;
        private AcknowledgeMode acknowledgeMode;
        private Integer concurrency;
        private Integer maxConcurrency;
        private Integer prefetch;
        private Integer transactionSize;

        public boolean isAutoStartup() {
            return this.autoStartup;
        }

        public void setAutoStartup(boolean autoStartup) {
            this.autoStartup = autoStartup;
        }

        public AcknowledgeMode getAcknowledgeMode() {
            return this.acknowledgeMode;
        }

        public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
            this.acknowledgeMode = acknowledgeMode;
        }

        public Integer getConcurrency() {
            return this.concurrency;
        }

        public void setConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
        }

        public Integer getMaxConcurrency() {
            return this.maxConcurrency;
        }

        public void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public Integer getPrefetch() {
            return this.prefetch;
        }

        public void setPrefetch(Integer prefetch) {
            this.prefetch = prefetch;
        }

        public Integer getTransactionSize() {
            return this.transactionSize;
        }

        public void setTransactionSize(Integer transactionSize) {
            this.transactionSize = transactionSize;
        }
    }

    public static class Ssl {
        private boolean enabled;
        private String keyStore;
        private String keyStorePassword;
        private String trustStore;
        private String trustStorePassword;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getKeyStore() {
            return this.keyStore;
        }

        public void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        public String getTrustStore() {
            return this.trustStore;
        }

        public void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }
    }
}

