/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitializedEvent;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

class DataSourceInitializedPublisher
implements BeanPostProcessor {
    @Autowired
    private ApplicationContext applicationContext;
    private DataSource dataSource;
    private JpaProperties properties;

    DataSourceInitializedPublisher() {
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource) {
            this.dataSource = (DataSource)bean;
        }
        if (bean instanceof JpaProperties) {
            this.properties = (JpaProperties)bean;
        }
        if (bean instanceof EntityManagerFactory && this.dataSource != null && this.isInitializingDatabase()) {
            this.applicationContext.publishEvent((ApplicationEvent)new DataSourceInitializedEvent(this.dataSource));
        }
        return bean;
    }

    private boolean isInitializingDatabase() {
        if (this.properties == null) {
            return true;
        }
        Map<String, String> hibernate = this.properties.getHibernateProperties(this.dataSource);
        return hibernate.containsKey("hibernate.hbm2ddl.auto");
    }

    static class Registrar
    implements ImportBeanDefinitionRegistrar {
        private static final String BEAN_NAME = "dataSourceInitializedPublisher";

        Registrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (!registry.containsBeanDefinition(BEAN_NAME)) {
                GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
                beanDefinition.setBeanClass(DataSourceInitializedPublisher.class);
                beanDefinition.setRole(2);
                beanDefinition.setSynthetic(true);
                registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)beanDefinition);
            }
        }
    }
}

