/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.DispatcherServletAutoConfiguration;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.MessageCodeFormatter;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.filter.HiddenHttpMethodFilter;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.i18n.FixedLocaleResolver;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurerAdapter.class})
@ConditionalOnMissingBean(value={WebMvcConfigurationSupport.class})
@Order(value=-2147483638)
@AutoConfigureAfter(value={DispatcherServletAutoConfiguration.class})
public class WebMvcAutoConfiguration {
    private static final String[] SERVLET_RESOURCE_LOCATIONS = new String[]{"/"};
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/resources/", "classpath:/resources/", "classpath:/static/", "classpath:/public/"};
    private static final String[] RESOURCE_LOCATIONS = new String[CLASSPATH_RESOURCE_LOCATIONS.length + SERVLET_RESOURCE_LOCATIONS.length];
    private static final String[] STATIC_INDEX_HTML_RESOURCES;
    public static String DEFAULT_PREFIX;
    public static String DEFAULT_SUFFIX;

    @Bean
    @ConditionalOnMissingBean(value={HiddenHttpMethodFilter.class})
    public HiddenHttpMethodFilter hiddenHttpMethodFilter() {
        return new HiddenHttpMethodFilter();
    }

    static {
        System.arraycopy(SERVLET_RESOURCE_LOCATIONS, 0, RESOURCE_LOCATIONS, 0, SERVLET_RESOURCE_LOCATIONS.length);
        System.arraycopy(CLASSPATH_RESOURCE_LOCATIONS, 0, RESOURCE_LOCATIONS, SERVLET_RESOURCE_LOCATIONS.length, CLASSPATH_RESOURCE_LOCATIONS.length);
        STATIC_INDEX_HTML_RESOURCES = new String[RESOURCE_LOCATIONS.length];
        for (int i = 0; i < STATIC_INDEX_HTML_RESOURCES.length; ++i) {
            WebMvcAutoConfiguration.STATIC_INDEX_HTML_RESOURCES[i] = RESOURCE_LOCATIONS[i] + "index.html";
        }
        DEFAULT_PREFIX = "";
        DEFAULT_SUFFIX = "";
    }

    @Configuration
    @EnableWebMvc
    @EnableConfigurationProperties(value={WebMvcProperties.class, ResourceProperties.class})
    public static class WebMvcAutoConfigurationAdapter
    extends WebMvcConfigurerAdapter {
        private static Log logger = LogFactory.getLog(WebMvcConfigurerAdapter.class);
        @Value(value="${spring.view.prefix:}")
        private String prefix = "";
        @Value(value="${spring.view.suffix:}")
        private String suffix = "";
        @Autowired
        private ResourceProperties resourceProperties = new ResourceProperties();
        @Autowired
        private WebMvcProperties mvcProperties = new WebMvcProperties();
        @Autowired
        private ListableBeanFactory beanFactory;
        @Autowired
        private ResourceLoader resourceLoader;
        @Autowired
        private HttpMessageConverters messageConverters;

        public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
            converters.addAll(this.messageConverters.getConverters());
        }

        @Bean
        @ConditionalOnMissingBean(value={InternalResourceViewResolver.class})
        public InternalResourceViewResolver defaultViewResolver() {
            InternalResourceViewResolver resolver = new InternalResourceViewResolver();
            resolver.setPrefix(this.prefix);
            resolver.setSuffix(this.suffix);
            return resolver;
        }

        @Bean
        @ConditionalOnMissingBean(value={RequestContextListener.class})
        public RequestContextListener requestContextListener() {
            return new RequestContextListener();
        }

        @Bean
        @ConditionalOnBean(value={View.class})
        public BeanNameViewResolver beanNameViewResolver() {
            BeanNameViewResolver resolver = new BeanNameViewResolver();
            resolver.setOrder(0x7FFFFFF5);
            return resolver;
        }

        @Bean
        @ConditionalOnBean(value={ViewResolver.class})
        @ConditionalOnMissingBean(name={"viewResolver"})
        public ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
            ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
            resolver.setContentNegotiationManager((ContentNegotiationManager)beanFactory.getBean(ContentNegotiationManager.class));
            resolver.setOrder(Integer.MIN_VALUE);
            return resolver;
        }

        @Bean
        @ConditionalOnMissingBean(value={LocaleResolver.class})
        @ConditionalOnProperty(prefix="spring.mvc.", value={"locale"})
        public LocaleResolver localeResolver() {
            return new FixedLocaleResolver(StringUtils.parseLocaleString((String)this.mvcProperties.getLocale()));
        }

        @Bean
        @ConditionalOnProperty(prefix="spring.mvc.", value={"date-format"})
        public Formatter<Date> dateFormatter() {
            return new DateFormatter(this.mvcProperties.getDateFormat());
        }

        public MessageCodesResolver getMessageCodesResolver() {
            if (this.mvcProperties.getMessageCodesResolverFormat() != null) {
                DefaultMessageCodesResolver resolver = new DefaultMessageCodesResolver();
                resolver.setMessageCodeFormatter((MessageCodeFormatter)this.mvcProperties.getMessageCodesResolverFormat());
                return resolver;
            }
            return null;
        }

        public void addFormatters(FormatterRegistry registry) {
            for (Converter converter : this.getBeansOfType(Converter.class)) {
                registry.addConverter(converter);
            }
            for (GenericConverter genericConverter : this.getBeansOfType(GenericConverter.class)) {
                registry.addConverter(genericConverter);
            }
            for (Formatter formatter : this.getBeansOfType(Formatter.class)) {
                registry.addFormatter(formatter);
            }
        }

        private <T> Collection<T> getBeansOfType(Class<T> type) {
            return this.beanFactory.getBeansOfType(type).values();
        }

        public void addResourceHandlers(ResourceHandlerRegistry registry) {
            if (!this.resourceProperties.isAddMappings()) {
                logger.debug((Object)"Default resource handling disabled");
                return;
            }
            Integer cachePeriod = this.resourceProperties.getCachePeriod();
            if (!registry.hasMappingForPattern("/webjars/**")) {
                registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).setCachePeriod(cachePeriod);
            }
            if (!registry.hasMappingForPattern("/**")) {
                registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(RESOURCE_LOCATIONS).setCachePeriod(cachePeriod);
            }
        }

        public void addViewControllers(ViewControllerRegistry registry) {
            this.addStaticIndexHtmlViewControllers(registry);
        }

        private void addStaticIndexHtmlViewControllers(ViewControllerRegistry registry) {
            for (String resource : STATIC_INDEX_HTML_RESOURCES) {
                if (!this.resourceLoader.getResource(resource).exists()) continue;
                try {
                    logger.info((Object)("Adding welcome page: " + this.resourceLoader.getResource(resource).getURL()));
                }
                catch (IOException ex) {
                    // empty catch block
                }
                registry.addViewController("/").setViewName("forward:/index.html");
                return;
            }
        }

        @Configuration
        public static class FaviconConfiguration {
            @Bean
            public SimpleUrlHandlerMapping faviconHandlerMapping() {
                SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
                mapping.setOrder(-2147483647);
                mapping.setUrlMap(Collections.singletonMap("**/favicon.ico", this.faviconRequestHandler()));
                return mapping;
            }

            @Bean
            public ResourceHttpRequestHandler faviconRequestHandler() {
                ResourceHttpRequestHandler requestHandler = new ResourceHttpRequestHandler();
                requestHandler.setLocations(Arrays.asList(new ClassPathResource("/")));
                return requestHandler;
            }
        }
    }
}

