/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.redis;

import java.net.UnknownHostException;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnClass(value={JedisConnection.class, RedisOperations.class, Jedis.class})
@EnableConfigurationProperties
public class RedisAutoConfiguration {
    @Bean(name={"org.springframework.autoconfigure.redis.RedisProperties"})
    @ConditionalOnMissingBean
    public RedisProperties redisProperties() {
        return new RedisProperties();
    }

    @Configuration
    protected static class RedisConfiguration {
        @Autowired
        private RedisProperties properties;

        protected RedisConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"redisTemplate"})
        public RedisOperations<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
            RedisTemplate template = new RedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }

        @Bean
        @ConditionalOnMissingBean(value={StringRedisTemplate.class})
        public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) throws UnknownHostException {
            StringRedisTemplate template = new StringRedisTemplate();
            template.setConnectionFactory(redisConnectionFactory);
            return template;
        }
    }

    @Configuration
    @ConditionalOnClass(value={GenericObjectPool.class})
    protected static class RedisPooledConnectionConfiguration {
        @Autowired
        private RedisProperties properties;

        protected RedisPooledConnectionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RedisConnectionFactory redisConnectionFactory() throws UnknownHostException {
            JedisConnectionFactory factory = this.createJedisConnectionFactory();
            factory.setHostName(this.properties.getHost());
            factory.setPort(this.properties.getPort());
            if (this.properties.getPassword() != null) {
                factory.setPassword(this.properties.getPassword());
            }
            return factory;
        }

        private JedisConnectionFactory createJedisConnectionFactory() {
            if (this.properties.getPool() != null) {
                return new JedisConnectionFactory(this.jedisPoolConfig());
            }
            return new JedisConnectionFactory();
        }

        private JedisPoolConfig jedisPoolConfig() {
            JedisPoolConfig config = new JedisPoolConfig();
            RedisProperties.Pool props = this.properties.getPool();
            config.setMaxTotal(props.getMaxActive());
            config.setMaxIdle(props.getMaxIdle());
            config.setMinIdle(props.getMinIdle());
            config.setMaxWaitMillis((long)props.getMaxWait());
            return config;
        }
    }

    @Configuration
    @ConditionalOnMissingClass(name={"org.apache.commons.pool2.impl.GenericObjectPool"})
    protected static class RedisConnectionConfiguration {
        @Autowired
        private RedisProperties properties;

        protected RedisConnectionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public RedisConnectionFactory redisConnectionFactory() throws UnknownHostException {
            JedisConnectionFactory factory = new JedisConnectionFactory();
            factory.setHostName(this.properties.getHost());
            factory.setPort(this.properties.getPort());
            if (this.properties.getPassword() != null) {
                factory.setPassword(this.properties.getPassword());
            }
            return factory;
        }
    }
}

