/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.groovy.template.web;

import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.util.Locale;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.boot.autoconfigure.groovy.template.web.GroovyTemplateView;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

public class GroovyTemplateViewResolver
extends UrlBasedViewResolver {
    private TemplateEngine engine = new SimpleTemplateEngine();

    public GroovyTemplateViewResolver() {
        this.setViewClass(GroovyTemplateView.class);
    }

    public void setTemplateEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        Resource resource = this.resolveResource(viewName, locale);
        if (resource == null) {
            return null;
        }
        Template template = this.engine.createTemplate(resource.getURL());
        GroovyTemplateView view = new GroovyTemplateView(template);
        view.setApplicationContext(this.getApplicationContext());
        view.setServletContext(this.getServletContext());
        view.setContentType(this.getContentType());
        return view;
    }

    private Resource resolveResource(String viewName, Locale locale) {
        String l10n = "";
        if (locale != null) {
            LocaleEditor localeEditor = new LocaleEditor();
            localeEditor.setValue((Object)locale);
            l10n = "_" + localeEditor.getAsText();
        }
        return this.resolveFromLocale(viewName, l10n);
    }

    private Resource resolveFromLocale(String viewName, String locale) {
        Resource resource = this.getApplicationContext().getResource(this.getPrefix() + viewName + locale + this.getSuffix());
        if (resource == null || !resource.exists()) {
            if (locale.isEmpty()) {
                return null;
            }
            int index = locale.lastIndexOf("_");
            return this.resolveFromLocale(viewName, locale.substring(0, index));
        }
        return resource;
    }
}

