/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class OnClassCondition
extends SpringBootCondition {
    OnClassCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap<String, Object> onMissingClasses;
        StringBuffer matchMessage = new StringBuffer();
        MultiValueMap<String, Object> onClasses = this.getAttributes(metadata, ConditionalOnClass.class);
        if (onClasses != null) {
            List<String> missing = this.getMatchingClasses(onClasses, MatchType.MISSING, context);
            if (!missing.isEmpty()) {
                return ConditionOutcome.noMatch("required @ConditionalOnClass classes not found: " + StringUtils.collectionToCommaDelimitedString(missing));
            }
            matchMessage.append("@ConditionalOnClass classes found: " + StringUtils.collectionToCommaDelimitedString(this.getMatchingClasses(onClasses, MatchType.PRESENT, context)));
        }
        if ((onMissingClasses = this.getAttributes(metadata, ConditionalOnMissingClass.class)) != null) {
            List<String> present = this.getMatchingClasses(onMissingClasses, MatchType.PRESENT, context);
            if (!present.isEmpty()) {
                return ConditionOutcome.noMatch("required @ConditionalOnMissing classes found: " + StringUtils.collectionToCommaDelimitedString(present));
            }
            matchMessage.append(matchMessage.length() == 0 ? "" : " ");
            matchMessage.append("@ConditionalOnMissing classes not found: " + StringUtils.collectionToCommaDelimitedString(this.getMatchingClasses(onMissingClasses, MatchType.MISSING, context)));
        }
        return ConditionOutcome.match(matchMessage.toString());
    }

    private MultiValueMap<String, Object> getAttributes(AnnotatedTypeMetadata metadata, Class<?> annotationType) {
        return metadata.getAllAnnotationAttributes(annotationType.getName(), true);
    }

    private List<String> getMatchingClasses(MultiValueMap<String, Object> attributes, MatchType matchType, ConditionContext context) {
        LinkedList<String> matches = new LinkedList<String>();
        this.addAll(matches, (List)attributes.get((Object)"value"));
        this.addAll(matches, (List)attributes.get((Object)"name"));
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            if (matchType.matches((String)iterator.next(), context)) continue;
            iterator.remove();
        }
        return matches;
    }

    private void addAll(List<String> list, List<Object> itemsToAdd) {
        if (itemsToAdd != null) {
            for (Object item : itemsToAdd) {
                for (String arrayItem : (String[])item) {
                    list.add(arrayItem.toString());
                }
            }
        }
    }

    private static enum MatchType {
        PRESENT{

            @Override
            public boolean matches(String className, ConditionContext context) {
                return ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader());
            }
        }
        ,
        MISSING{

            @Override
            public boolean matches(String className, ConditionContext context) {
                return !ClassUtils.isPresent((String)className, (ClassLoader)context.getClassLoader());
            }
        };


        public abstract boolean matches(String var1, ConditionContext var2);
    }
}

