/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.websocket;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.EmbeddedServletContainerAutoConfiguration;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@ConditionalOnClass(value={WebSocketHandler.class})
@AutoConfigureBefore(value={EmbeddedServletContainerAutoConfiguration.class})
@ConditionalOnMissingBean(value={WebSocketConfigurer.class})
@EnableWebSocket
public class WebSocketAutoConfiguration {
    private static Log logger = LogFactory.getLog(WebSocketAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(name={"org.apache.tomcat.websocket.server.WsSci"})
    protected static class TomcatWebSocketConfiguration {
        protected TomcatWebSocketConfiguration() {
        }

        @Bean
        public TomcatEmbeddedServletContainerFactory tomcatEmbeddedServletContainerFactory() {
            TomcatEmbeddedServletContainerFactory factory = new TomcatEmbeddedServletContainerFactory(){

                protected void postProcessContext(Context context) {
                    context.addServletContainerInitializer((ServletContainerInitializer)BeanUtils.instantiate((Class)ClassUtils.resolveClassName((String)"org.apache.tomcat.websocket.server.WsSci", null)), null);
                }
            };
            return factory;
        }
    }

    @Configuration
    protected static class WebSocketRegistrationConfiguration
    implements BeanPostProcessor,
    BeanFactoryAware,
    WebSocketConfigurer {
        private final Map<String, WebSocketHandler> prefixes = new HashMap<String, WebSocketHandler>();
        private ListableBeanFactory beanFactory;

        protected WebSocketRegistrationConfiguration() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof WebSocketHandler && beanName.startsWith("/")) {
                this.prefixes.put(beanName, (WebSocketHandler)bean);
            }
            return bean;
        }

        private WebSocketHandler getHandler(String prefix) {
            return this.prefixes.get(prefix);
        }

        private String[] getPrefixes() {
            return this.prefixes.keySet().toArray(new String[this.prefixes.size()]);
        }

        public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
            this.beanFactory.getBeansOfType(WebSocketHandler.class);
            for (String prefix : this.getPrefixes()) {
                logger.info((Object)("Adding SockJS handler: " + prefix));
                registry.addHandler(this.getHandler(prefix), new String[]{prefix}).withSockJS();
            }
        }
    }
}

