/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.AutoConfigurationSorter;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;

@Order(value=0x7FFFFFFF)
class EnableAutoConfigurationImportSelector
implements DeferredImportSelector,
BeanClassLoaderAware,
ResourceLoaderAware {
    private ClassLoader beanClassLoader;
    private ResourceLoader resourceLoader;

    EnableAutoConfigurationImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        try {
            AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(EnableAutoConfiguration.class.getName(), true));
            List<String> factories = new ArrayList<String>(new LinkedHashSet(SpringFactoriesLoader.loadFactoryNames(EnableAutoConfiguration.class, (ClassLoader)this.beanClassLoader)));
            factories.removeAll(Arrays.asList(attributes.getStringArray("exclude")));
            factories = new AutoConfigurationSorter(this.resourceLoader).getInPriorityOrder(factories);
            return factories.toArray(new String[factories.size()]);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

