/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure;

import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

public abstract class AutoConfigurationPackages {
    private static final String BEAN = AutoConfigurationPackages.class.getName();

    public static List<String> get(BeanFactory beanFactory) {
        try {
            return Collections.singletonList(((BasePackage)beanFactory.getBean(BEAN, BasePackage.class)).toString());
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new IllegalStateException("Unable to retrieve @EnableAutoConfiguration base packages");
        }
    }

    static void set(BeanDefinitionRegistry registry, String packageName) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(BasePackage.class);
        beanDefinition.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)packageName);
        beanDefinition.setRole(2);
        registry.registerBeanDefinition(BEAN, (BeanDefinition)beanDefinition);
    }

    static final class BasePackage {
        private final String name;

        public BasePackage(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    @Order(value=-2147483648)
    static class Registrar
    implements ImportBeanDefinitionRegistrar {
        Registrar() {
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AutoConfigurationPackages.set(registry, ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
    }
}

