/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.sql.SQLException;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.jdbc.AbstractDataSourceConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataAccessResourceFailureException;

@Configuration
public class CommonsDataSourceConfiguration
extends AbstractDataSourceConfiguration {
    private static Log logger = LogFactory.getLog(CommonsDataSourceConfiguration.class);
    private BasicDataSource pool;

    public CommonsDataSourceConfiguration() {
        this.setInitialSize(0);
    }

    @Bean
    public DataSource dataSource() {
        logger.info((Object)"Hint: using Commons DBCP BasicDataSource. It's going to work, but the Tomcat DataSource is more reliable.");
        this.pool = new BasicDataSource();
        this.pool.setDriverClassName(this.getDriverClassName());
        this.pool.setUrl(this.getUrl());
        if (this.getUsername() != null) {
            this.pool.setUsername(this.getUsername());
        }
        if (this.getPassword() != null) {
            this.pool.setPassword(this.getPassword());
        }
        this.pool.setInitialSize(this.getInitialSize());
        this.pool.setMaxActive(this.getMaxActive());
        this.pool.setMaxIdle(this.getMaxIdle());
        this.pool.setMinIdle(this.getMinIdle());
        this.pool.setTestOnBorrow(this.isTestOnBorrow());
        this.pool.setTestOnReturn(this.isTestOnReturn());
        this.pool.setValidationQuery(this.getValidationQuery());
        return this.pool;
    }

    @PreDestroy
    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not close data source", (Throwable)ex);
            }
        }
    }
}

