/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data;

import java.lang.annotation.Annotation;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryBeanNameGenerator;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

public abstract class AbstractRepositoryConfigurationSourceSupport
implements BeanFactoryAware,
ImportBeanDefinitionRegistrar,
BeanClassLoaderAware,
EnvironmentAware {
    private ClassLoader beanClassLoader;
    private BeanFactory beanFactory;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        AnnotationRepositoryConfigurationSource configurationSource = this.getConfigurationSource();
        RepositoryConfigurationExtension extension = this.getRepositoryConfigurationExtension();
        extension.registerBeansForRoot(registry, (RepositoryConfigurationSource)configurationSource);
        RepositoryBeanNameGenerator generator = new RepositoryBeanNameGenerator();
        generator.setBeanClassLoader(this.beanClassLoader);
        Collection repositoryConfigurations = extension.getRepositoryConfigurations((RepositoryConfigurationSource)configurationSource, (ResourceLoader)resourceLoader);
        for (RepositoryConfiguration repositoryConfiguration : repositoryConfigurations) {
            RepositoryBeanDefinitionBuilder builder = new RepositoryBeanDefinitionBuilder(repositoryConfiguration, extension);
            BeanDefinitionBuilder definitionBuilder = builder.build(registry, (ResourceLoader)resourceLoader);
            extension.postProcess(definitionBuilder, configurationSource);
            String beanName = generator.generateBeanName((BeanDefinition)definitionBuilder.getBeanDefinition(), registry);
            registry.registerBeanDefinition(beanName, (BeanDefinition)definitionBuilder.getBeanDefinition());
        }
    }

    private AnnotationRepositoryConfigurationSource getConfigurationSource() {
        StandardAnnotationMetadata metadata = new StandardAnnotationMetadata(this.getConfiguration(), true);
        AnnotationRepositoryConfigurationSource configurationSource = new AnnotationRepositoryConfigurationSource((AnnotationMetadata)metadata, this.getAnnotation(), this.environment){

            public Iterable<String> getBasePackages() {
                return AbstractRepositoryConfigurationSourceSupport.this.getBasePackages();
            }
        };
        return configurationSource;
    }

    protected Iterable<String> getBasePackages() {
        return AutoConfigurationPackages.get(this.beanFactory);
    }

    protected abstract Class<? extends Annotation> getAnnotation();

    protected abstract Class<?> getConfiguration();

    protected abstract RepositoryConfigurationExtension getRepositoryConfigurationExtension();

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

