/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.gradle;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.springframework.util.StringUtils;

public class PropertiesTask
extends DefaultTask {
    @Input
    private Configuration configuration;
    @OutputFile
    private File output;
    @Input
    private String name = "thin";
    @Input
    private String profile;

    @TaskAction
    public void generate() {
        Properties properties = this.getThinProperties(this.configuration);
        try {
            String filename = this.getFileName();
            this.output.mkdirs();
            properties.store(new FileOutputStream(new File(this.output, filename)), "Generated by thin gradle plugin");
        }
        catch (Exception e) {
            throw new TaskExecutionException((Task)this, (Throwable)e);
        }
    }

    protected Properties getThinProperties(Configuration configuration) {
        Properties properties = new Properties();
        properties.setProperty("computed", "true");
        if (configuration != null) {
            for (ResolvedArtifact artifact : configuration.getResolvedConfiguration().getResolvedArtifacts()) {
                properties.setProperty("dependencies." + this.key(artifact, properties), this.coordinates(artifact, true));
            }
        }
        return properties;
    }

    private String key(ResolvedArtifact dependency, Properties props) {
        String key = dependency.getModuleVersion().getId().getName();
        if (!StringUtils.isEmpty((Object)dependency.getClassifier())) {
            key = key + "." + dependency.getClassifier();
        }
        int counter = 1;
        while (props.get("dependencies." + key) != null) {
            key = key + "." + counter++;
        }
        return key;
    }

    private String coordinates(ResolvedArtifact artifact, boolean withVersion) {
        String classifier = artifact.getClassifier();
        String extension = artifact.getType();
        ModuleVersionIdentifier artifactId = artifact.getModuleVersion().getId();
        return artifactId.getGroup() + ":" + artifactId.getName() + (StringUtils.hasText((String)extension) && (!"jar".equals(extension) || StringUtils.hasText((String)classifier)) ? ":" + extension : "") + (StringUtils.hasText((String)classifier) ? ":" + classifier : "") + (withVersion ? ":" + artifactId.getVersion() : "");
    }

    private String getFileName() {
        String profile = StringUtils.hasText((String)this.profile) ? "-" + this.profile : "";
        return this.name + profile + ".properties";
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }
}

