/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.validation.valang.custom;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.sample.domain.LineItem;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.Function;

public class ValidateShippingPricesFunction
extends AbstractFunction {
    private static final BigDecimal BD_MIN = new BigDecimal(0.0);
    private static final BigDecimal BD_MAX = new BigDecimal(9.999999999E7);

    public ValidateShippingPricesFunction(Function[] arguments, int line, int column) {
        super(arguments, line, column);
        this.definedExactNumberOfArguments(1);
    }

    protected Object doGetResult(Object target) throws Exception {
        List lineItems = (List)this.getArguments()[0].getResult(target);
        Iterator i = lineItems.iterator();
        while (i.hasNext()) {
            LineItem item = (LineItem)i.next();
            if (BD_MIN.compareTo(item.getShippingPrice()) <= 0 && BD_MAX.compareTo(item.getShippingPrice()) >= 0) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

