/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.validation.valang.custom;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.springframework.batch.sample.domain.LineItem;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.Function;

public class ValidateDiscountsFunction
extends AbstractFunction {
    private static final BigDecimal BD_0 = new BigDecimal(0.0);
    private static final BigDecimal BD_PERC_MAX = new BigDecimal(100.0);

    public ValidateDiscountsFunction(Function[] arguments, int line, int column) {
        super(arguments, line, column);
        this.definedExactNumberOfArguments(1);
    }

    protected Object doGetResult(Object target) throws Exception {
        List lineItems = (List)this.getArguments()[0].getResult(target);
        Iterator i = lineItems.iterator();
        while (i.hasNext()) {
            LineItem item = (LineItem)i.next();
            if (!(BD_0.compareTo(item.getDiscountPerc()) != 0 ? BD_0.compareTo(item.getDiscountPerc()) > 0 || BD_PERC_MAX.compareTo(item.getDiscountPerc()) < 0 || BD_0.compareTo(item.getDiscountAmount()) != 0 : BD_0.compareTo(item.getDiscountAmount()) > 0 || item.getPrice().compareTo(item.getDiscountAmount()) < 0)) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

