/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.launch;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.support.ClassPathXmlApplicationContextJobFactory;
import org.springframework.batch.core.repository.DuplicateJobException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.ResourceLoader;

public class TaskExecutorLauncher
implements ResourceLoaderAware {
    private JobRegistry registry;
    private ResourceLoader resourceLoader;
    private ApplicationContext parentContext = null;
    private static List errors = new ArrayList();
    static /* synthetic */ Class class$org$springframework$batch$core$Job;

    public void setRegistry(JobRegistry registry) {
        this.registry = registry;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public static List getErrors() {
        return errors;
    }

    private void register(String[] paths) throws DuplicateJobException {
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            XmlBeanFactory beanFactory = new XmlBeanFactory(this.resourceLoader.getResource(path), (BeanFactory)this.parentContext.getAutowireCapableBeanFactory());
            String[] names = beanFactory.getBeanNamesForType(class$org$springframework$batch$core$Job == null ? TaskExecutorLauncher.class$("org.springframework.batch.core.Job") : class$org$springframework$batch$core$Job);
            for (int j = 0; j < names.length; ++j) {
                this.registry.register((JobFactory)new ClassPathXmlApplicationContextJobFactory(names[j], path, this.parentContext));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        final TaskExecutorLauncher launcher = new TaskExecutorLauncher();
        errors.clear();
        new Thread(new Runnable(){

            public void run() {
                try {
                    launcher.run();
                }
                catch (RuntimeException e) {
                    errors.add(e);
                    throw e;
                }
            }
        }).start();
        while (launcher.parentContext == null) {
            Thread.sleep(100L);
        }
        String[] paths = new String[]{"jobs/adhocLoopJob.xml", "jobs/footballJob.xml"};
        launcher.register(paths);
        System.out.println("Started application.  Please connect using JMX (remember to use -Dcom.sun.management.jmxremote if you can't see anything in Jconsole).");
        System.in.read();
    }

    private void run() {
        ClassPathXmlApplicationContext parent = new ClassPathXmlApplicationContext("adhoc-job-launcher-context.xml");
        parent.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this, 2, false);
        parent.getAutowireCapableBeanFactory().initializeBean((Object)this, "taskExecutorLauncher");
        this.parentContext = parent;
    }
}

