/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.item.writer;

import org.springframework.batch.item.support.AbstractItemWriter;
import org.springframework.batch.sample.dao.CustomerCreditDao;
import org.springframework.batch.sample.domain.CustomerCredit;

public class CustomerCreditUpdateWriter
extends AbstractItemWriter {
    private double creditFilter = 800.0;
    private CustomerCreditDao dao;

    public void write(Object data) throws Exception {
        CustomerCredit customerCredit = (CustomerCredit)data;
        if (customerCredit.getCredit().doubleValue() > this.creditFilter) {
            this.dao.writeCredit(customerCredit);
        }
    }

    public void setCreditFilter(double creditFilter) {
        this.creditFilter = creditFilter;
    }

    public void setDao(CustomerCreditDao dao) {
        this.dao = dao;
    }
}

