/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.item.reader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ReaderNotOpenException;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class StagingItemReader
extends JdbcDaoSupport
implements ItemStream,
ItemReader,
StepExecutionListener {
    private static final String BUFFER_KEY = StagingItemReader.class.getName() + ".BUFFER";
    private static Log logger = LogFactory.getLog((Class)StagingItemReader.class);
    private StepExecution stepExecution;
    private LobHandler lobHandler = new DefaultLobHandler();
    private Object lock = new Object();
    private volatile boolean initialized = false;
    private volatile Iterator keys;

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void close(ExecutionContext executionContext) {
        this.initialized = false;
        this.keys = null;
        if (TransactionSynchronizationManager.hasResource((Object)BUFFER_KEY)) {
            TransactionSynchronizationManager.unbindResource((Object)BUFFER_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(ExecutionContext executionContext) {
        Object object = this.lock;
        synchronized (object) {
            if (this.keys == null) {
                this.keys = this.retrieveKeys().iterator();
                logger.info((Object)"Keys obtained for staging.");
                this.initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List retrieveKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.getJdbcTemplate().query("SELECT ID FROM BATCH_STAGING WHERE JOB_ID=? AND PROCESSED=? ORDER BY ID", new Object[]{this.stepExecution.getJobExecution().getJobId(), "N"}, new RowMapper(){

                public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return new Long(rs.getLong(1));
                }
            });
        }
    }

    public Object read() throws Exception {
        Long id = this.doRead();
        if (id == null) {
            return null;
        }
        Object result = this.getJdbcTemplate().queryForObject("SELECT VALUE FROM BATCH_STAGING WHERE ID=?", new Object[]{id}, new RowMapper(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                byte[] blob = StagingItemReader.this.lobHandler.getBlobAsBytes(rs, 1);
                return SerializationUtils.deserialize((byte[])blob);
            }
        });
        int count = this.getJdbcTemplate().update("UPDATE BATCH_STAGING SET PROCESSED=? WHERE ID=? AND PROCESSED=?", new Object[]{"Y", id, "N"});
        if (count != 1) {
            throw new OptimisticLockingFailureException("The staging record with ID=" + id + " was updated concurrently when trying to mark as complete (updated " + count + " records.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long doRead() {
        if (!this.initialized) {
            throw new ReaderNotOpenException("ItemStream must be open before it can be read.");
        }
        Long key = this.getBuffer().next();
        if (key == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.keys.hasNext()) {
                    Assert.state((boolean)TransactionSynchronizationManager.isActualTransactionActive(), (String)"Transaction not active for this thread.");
                    Long next = (Long)this.keys.next();
                    this.getBuffer().add(next);
                    key = next;
                    logger.debug((Object)("Retrieved key from list: " + key));
                }
            }
        } else {
            logger.debug((Object)("Retrieved key from buffer: " + key));
        }
        return key;
    }

    private StagingBuffer getBuffer() {
        if (!TransactionSynchronizationManager.hasResource((Object)BUFFER_KEY)) {
            TransactionSynchronizationManager.bindResource((Object)BUFFER_KEY, (Object)new StagingBuffer());
        }
        return (StagingBuffer)TransactionSynchronizationManager.getResource((Object)BUFFER_KEY);
    }

    public boolean recover(Object data, Throwable cause) {
        return false;
    }

    public void mark() {
        this.getBuffer().commit();
    }

    public void reset() {
        this.getBuffer().rollback();
    }

    public void update(ExecutionContext executionContext) {
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public ExitStatus onErrorInStep(StepExecution stepExecution, Throwable e) {
        return null;
    }

    private static class StagingBuffer {
        private List list = new ArrayList();
        private Iterator iter = new ArrayList().iterator();

        private StagingBuffer() {
        }

        public Long next() {
            if (this.iter.hasNext()) {
                return (Long)this.iter.next();
            }
            return null;
        }

        public void add(Long next) {
            this.list.add(next);
        }

        public void rollback() {
            logger.debug((Object)("Resetting buffer on rollback: " + this.list));
            this.iter = new ArrayList(this.list).iterator();
        }

        public void commit() {
            logger.debug((Object)("Clearing buffer on commit: " + this.list));
            this.list.clear();
            this.iter = new ArrayList().iterator();
        }

        public String toString() {
            return "list=" + this.list + "; iter.hasNext()=" + this.iter.hasNext();
        }
    }
}

