/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.sample.dao.TradeDao;
import org.springframework.batch.sample.domain.Trade;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;

public class JdbcTradeDao
implements TradeDao {
    private Log log = LogFactory.getLog((Class)JdbcTradeDao.class);
    private static final String INSERT_TRADE_RECORD = "INSERT INTO trade (id, isin, quantity, price, customer) VALUES (?, ?, ? ,?, ?)";
    private JdbcOperations jdbcTemplate;
    private DataFieldMaxValueIncrementer incrementer;

    public void writeTrade(Trade trade) {
        Long id = new Long(this.incrementer.nextLongValue());
        this.log.debug((Object)("Processing: " + trade));
        this.jdbcTemplate.update(INSERT_TRADE_RECORD, new Object[]{id, trade.getIsin(), new Long(trade.getQuantity()), trade.getPrice(), trade.getCustomer()});
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public void setIncrementer(DataFieldMaxValueIncrementer incrementer) {
        this.incrementer = incrementer;
    }
}

