/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.dao;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatListener;
import org.springframework.batch.sample.dao.CustomerCreditDao;
import org.springframework.batch.sample.domain.CustomerCredit;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class HibernateCreditDao
extends HibernateDaoSupport
implements CustomerCreditDao,
RepeatListener {
    private int failOnFlush = -1;
    private List errors = new ArrayList();

    public List getErrors() {
        return this.errors;
    }

    public void writeCredit(CustomerCredit customerCredit) {
        if (customerCredit.getId() == this.failOnFlush) {
            CustomerCredit newCredit = new CustomerCredit();
            newCredit.setId(customerCredit.getId());
            newCredit.setName(customerCredit.getName());
            newCredit.setCredit(customerCredit.getCredit());
            this.getHibernateTemplate().save((Object)newCredit);
        } else {
            this.getHibernateTemplate().update((Object)customerCredit);
        }
    }

    public void write(Object output) {
        this.writeCredit((CustomerCredit)output);
    }

    public void setFailOnFlush(int failOnFlush) {
        this.failOnFlush = failOnFlush;
    }

    public void onError(RepeatContext context, Throwable e) {
        this.errors.add(e);
    }

    public void after(RepeatContext context, ExitStatus result) {
    }

    public void before(RepeatContext context) {
    }

    public void close(RepeatContext context) {
    }

    public void open(RepeatContext context) {
    }
}

