/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.config.xml;

import org.springframework.batch.core.step.item.SimpleChunkProcessor;
import org.springframework.batch.integration.chunk.ChunkProcessorChunkHandler;
import org.springframework.batch.item.support.PassThroughItemProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ServiceActivatorFactoryBean;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RemoteChunkingWorkerParser
extends AbstractBeanDefinitionParser {
    private static final String INPUT_CHANNEL_ATTRIBUTE = "input-channel";
    private static final String OUTPUT_CHANNEL_ATTRIBUTE = "output-channel";
    private static final String ITEM_PROCESSOR_ATTRIBUTE = "item-processor";
    private static final String ITEM_WRITER_ATTRIBUTE = "item-writer";
    private static final String ITEM_PROCESSOR_PROPERTY_NAME = "itemProcessor";
    private static final String ITEM_WRITER_PROPERTY_NAME = "itemWriter";
    private static final String CHUNK_PROCESSOR_PROPERTY_NAME = "chunkProcessor";
    private static final String CHUNK_PROCESSOR_CHUNK_HANDLER_BEAN_NAME_PREFIX = "chunkProcessorChunkHandler_";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String id = element.getAttribute("id");
        Assert.hasText((String)id, (String)"The id attribute must be specified");
        String inputChannel = element.getAttribute(INPUT_CHANNEL_ATTRIBUTE);
        Assert.hasText((String)inputChannel, (String)"The input-channel attribute must be specified");
        String outputChannel = element.getAttribute(OUTPUT_CHANNEL_ATTRIBUTE);
        Assert.hasText((String)outputChannel, (String)"The output-channel attribute must be specified");
        String itemProcessor = element.getAttribute(ITEM_PROCESSOR_ATTRIBUTE);
        String itemWriter = element.getAttribute(ITEM_WRITER_ATTRIBUTE);
        Assert.hasText((String)itemWriter, (String)"The item-writer attribute must be specified");
        BeanDefinitionRegistry beanDefinitionRegistry = parserContext.getRegistry();
        BeanDefinitionBuilder chunkProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleChunkProcessor.class).addPropertyReference(ITEM_WRITER_PROPERTY_NAME, itemWriter);
        if (StringUtils.hasText((String)itemProcessor)) {
            chunkProcessorBuilder.addPropertyReference(ITEM_PROCESSOR_PROPERTY_NAME, itemProcessor);
        } else {
            chunkProcessorBuilder.addPropertyValue(ITEM_PROCESSOR_PROPERTY_NAME, (Object)new PassThroughItemProcessor());
        }
        AbstractBeanDefinition chunkProcessorChunkHandler = BeanDefinitionBuilder.genericBeanDefinition(ChunkProcessorChunkHandler.class).addPropertyValue(CHUNK_PROCESSOR_PROPERTY_NAME, (Object)chunkProcessorBuilder.getBeanDefinition()).getBeanDefinition();
        beanDefinitionRegistry.registerBeanDefinition(CHUNK_PROCESSOR_CHUNK_HANDLER_BEAN_NAME_PREFIX + id, (BeanDefinition)chunkProcessorChunkHandler);
        new ServiceActivatorParser(id).parse(element, parserContext);
        return null;
    }

    private static class ServiceActivatorParser
    extends AbstractConsumerEndpointParser {
        private static final String TARGET_METHOD_NAME_PROPERTY_NAME = "targetMethodName";
        private static final String TARGET_OBJECT_PROPERTY_NAME = "targetObject";
        private static final String HANDLE_CHUNK_METHOD_NAME = "handleChunk";
        private static final String CHUNK_PROCESSOR_CHUNK_HANDLER_BEAN_NAME_PREFIX = "chunkProcessorChunkHandler_";
        private String id;

        public ServiceActivatorParser(String id) {
            this.id = id;
        }

        protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ServiceActivatorFactoryBean.class);
            builder.addPropertyValue(TARGET_METHOD_NAME_PROPERTY_NAME, (Object)HANDLE_CHUNK_METHOD_NAME);
            builder.addPropertyValue(TARGET_OBJECT_PROPERTY_NAME, (Object)new RuntimeBeanReference("chunkProcessorChunkHandler_" + this.id));
            return builder;
        }
    }
}

