/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.integration.chunk;

import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.FaultTolerantStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.item.KeyGenerator;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.integration.chunk.ChunkMessageChannelItemWriter;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.PollableChannel;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.policy.RetryContextCache;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

public class RemoteChunkingMasterStepBuilder<I, O>
extends FaultTolerantStepBuilder<I, O> {
    private MessagingTemplate messagingTemplate;
    private PollableChannel inputChannel;
    private MessageChannel outputChannel;
    private final int DEFAULT_MAX_WAIT_TIMEOUTS = 40;
    private static final long DEFAULT_THROTTLE_LIMIT = 6L;
    private int maxWaitTimeouts = 40;
    private long throttleLimit = 6L;

    public RemoteChunkingMasterStepBuilder(String stepName) {
        super((StepBuilderHelper)new StepBuilder(stepName));
    }

    public RemoteChunkingMasterStepBuilder<I, O> inputChannel(PollableChannel inputChannel) {
        Assert.notNull((Object)inputChannel, (String)"inputChannel must not be null");
        this.inputChannel = inputChannel;
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> outputChannel(MessageChannel outputChannel) {
        Assert.notNull((Object)outputChannel, (String)"outputChannel must not be null");
        this.outputChannel = outputChannel;
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> messagingTemplate(MessagingTemplate messagingTemplate) {
        Assert.notNull((Object)messagingTemplate, (String)"messagingTemplate must not be null");
        this.messagingTemplate = messagingTemplate;
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> maxWaitTimeouts(int maxWaitTimeouts) {
        Assert.isTrue((maxWaitTimeouts > 0 ? 1 : 0) != 0, (String)"maxWaitTimeouts must be greater than zero");
        this.maxWaitTimeouts = maxWaitTimeouts;
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> throttleLimit(long throttleLimit) {
        Assert.isTrue((throttleLimit > 0L ? 1 : 0) != 0, (String)"throttleLimit must be greater than zero");
        this.throttleLimit = throttleLimit;
        return this;
    }

    public TaskletStep build() {
        Assert.notNull((Object)this.inputChannel, (String)"An InputChannel must be provided");
        Assert.state((this.outputChannel == null || this.messagingTemplate == null ? 1 : 0) != 0, (String)"You must specify either an outputChannel or a messagingTemplate but not both.");
        if (this.messagingTemplate == null) {
            this.messagingTemplate = new MessagingTemplate();
            this.messagingTemplate.setDefaultChannel(this.outputChannel);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No messagingTemplate was provided, using a default one");
            }
        }
        ChunkMessageChannelItemWriter chunkMessageChannelItemWriter = new ChunkMessageChannelItemWriter();
        chunkMessageChannelItemWriter.setMessagingOperations(this.messagingTemplate);
        chunkMessageChannelItemWriter.setMaxWaitTimeouts(this.maxWaitTimeouts);
        chunkMessageChannelItemWriter.setThrottleLimit(this.throttleLimit);
        chunkMessageChannelItemWriter.setReplyChannel(this.inputChannel);
        super.writer(chunkMessageChannelItemWriter);
        return super.build();
    }

    public RemoteChunkingMasterStepBuilder<I, O> reader(ItemReader<? extends I> reader) {
        super.reader(reader);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> repository(JobRepository jobRepository) {
        super.repository(jobRepository);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> transactionManager(PlatformTransactionManager transactionManager) {
        super.transactionManager(transactionManager);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> listener(Object listener) {
        super.listener(listener);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> listener(SkipListener<? super I, ? super O> listener) {
        super.listener(listener);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> listener(ChunkListener listener) {
        super.listener(listener);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> transactionAttribute(TransactionAttribute transactionAttribute) {
        super.transactionAttribute(transactionAttribute);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> listener(RetryListener listener) {
        super.listener(listener);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> keyGenerator(KeyGenerator keyGenerator) {
        super.keyGenerator(keyGenerator);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> retryLimit(int retryLimit) {
        super.retryLimit(retryLimit);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> retryPolicy(RetryPolicy retryPolicy) {
        super.retryPolicy(retryPolicy);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> backOffPolicy(BackOffPolicy backOffPolicy) {
        super.backOffPolicy(backOffPolicy);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> retryContextCache(RetryContextCache retryContextCache) {
        super.retryContextCache(retryContextCache);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> skipLimit(int skipLimit) {
        super.skipLimit(skipLimit);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> noSkip(Class<? extends Throwable> type) {
        super.noSkip(type);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> skip(Class<? extends Throwable> type) {
        super.skip(type);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> skipPolicy(SkipPolicy skipPolicy) {
        super.skipPolicy(skipPolicy);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> noRollback(Class<? extends Throwable> type) {
        super.noRollback(type);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> noRetry(Class<? extends Throwable> type) {
        super.noRetry(type);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> retry(Class<? extends Throwable> type) {
        super.retry(type);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> stream(ItemStream stream) {
        super.stream(stream);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> chunk(int chunkSize) {
        super.chunk(chunkSize);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> chunk(CompletionPolicy completionPolicy) {
        super.chunk(completionPolicy);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> writer(ItemWriter<? super O> writer) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("When configuring a master step for remote chunking, the item writer will be automatically set to an instance of ChunkMessageChannelItemWriter. The item writer must not be provided in this case.");
    }

    public RemoteChunkingMasterStepBuilder<I, O> readerIsTransactionalQueue() {
        super.readerIsTransactionalQueue();
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> listener(ItemReadListener<? super I> listener) {
        super.listener(listener);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> listener(ItemWriteListener<? super O> listener) {
        super.listener(listener);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> chunkOperations(RepeatOperations repeatTemplate) {
        super.chunkOperations(repeatTemplate);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> exceptionHandler(ExceptionHandler exceptionHandler) {
        super.exceptionHandler(exceptionHandler);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> stepOperations(RepeatOperations repeatTemplate) {
        super.stepOperations(repeatTemplate);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> startLimit(int startLimit) {
        super.startLimit(startLimit);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> listener(StepExecutionListener listener) {
        super.listener(listener);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> allowStartIfComplete(boolean allowStartIfComplete) {
        super.allowStartIfComplete(allowStartIfComplete);
        return this;
    }

    public RemoteChunkingMasterStepBuilder<I, O> processor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        super.processor(itemProcessor);
        return this;
    }
}

