/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.ldif;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.infrastructure.item.ldif.RecordCallbackHandler;
import org.springframework.batch.infrastructure.item.ldif.RecordMapper;
import org.springframework.batch.infrastructure.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.ldap.core.LdapAttributes;
import org.springframework.ldap.ldif.parser.LdifParser;
import org.springframework.util.Assert;

public class MappingLdifReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(MappingLdifReader.class);
    private Resource resource;
    private @Nullable LdifParser ldifParser;
    private int recordCount = 0;
    private int recordsToSkip = 0;
    private boolean strict = true;
    private @Nullable RecordCallbackHandler skippedRecordsCallback;
    private @Nullable RecordMapper<T> recordMapper;

    public MappingLdifReader(Resource resource) {
        Assert.notNull((Object)resource, (String)"The resource must not be null");
        this.resource = resource;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSkippedRecordsCallback(RecordCallbackHandler skippedRecordsCallback) {
        this.skippedRecordsCallback = skippedRecordsCallback;
    }

    public void setRecordsToSkip(int recordsToSkip) {
        this.recordsToSkip = recordsToSkip;
    }

    public void setRecordMapper(RecordMapper<T> recordMapper) {
        this.recordMapper = recordMapper;
    }

    @Override
    protected void doClose() throws Exception {
        if (this.ldifParser != null) {
            this.ldifParser.close();
        }
        this.recordCount = 0;
    }

    @Override
    protected void doOpen() throws Exception {
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode): " + String.valueOf(this.resource));
            }
            LOG.warn((Object)("Input resource does not exist " + this.resource.getDescription()));
            return;
        }
        this.ldifParser.open();
        for (int i = 0; i < this.recordsToSkip; ++i) {
            LdapAttributes record = this.ldifParser.getRecord();
            if (this.skippedRecordsCallback == null) continue;
            this.skippedRecordsCallback.handleRecord(record);
        }
    }

    @Override
    protected @Nullable T doRead() throws Exception {
        LdapAttributes attributes = null;
        try {
            if (this.ldifParser != null) {
                while (attributes == null && this.ldifParser.hasMoreRecords()) {
                    attributes = this.ldifParser.getRecord();
                }
                ++this.recordCount;
                return this.recordMapper.mapRecord(attributes);
            }
            return null;
        }
        catch (Exception ex) {
            LOG.error((Object)("Parsing error at record " + this.recordCount + " in resource=" + this.resource.getDescription() + ", input=[" + String.valueOf(attributes) + "]"), (Throwable)ex);
            throw ex;
        }
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ldifParser == null) {
            this.ldifParser = new LdifParser(this.resource);
        }
    }
}

