/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.database;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.database.AbstractCursorItemReader;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.metadata.CallMetaDataContext;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.Assert;

public class StoredProcedureItemReader<T>
extends AbstractCursorItemReader<T> {
    private @Nullable CallableStatement callableStatement;
    private @Nullable PreparedStatementSetter preparedStatementSetter;
    private String procedureName;
    private @Nullable String callString;
    private RowMapper<T> rowMapper;
    private SqlParameter[] parameters = new SqlParameter[0];
    private boolean function = false;
    private int refCursorPosition = 0;

    public StoredProcedureItemReader(DataSource dataSource, String procedureName, RowMapper<T> rowMapper) {
        super(dataSource);
        Assert.notNull((Object)procedureName, (String)"The stored procedure name must not be null");
        Assert.notNull(rowMapper, (String)"RowMapper must not be null");
        this.procedureName = procedureName;
        this.rowMapper = rowMapper;
    }

    public void setRowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public void setPreparedStatementSetter(PreparedStatementSetter preparedStatementSetter) {
        this.preparedStatementSetter = preparedStatementSetter;
    }

    public void setParameters(SqlParameter[] parameters) {
        this.parameters = parameters;
    }

    public void setFunction(boolean function) {
        this.function = function;
    }

    public void setRefCursorPosition(int refCursorPosition) {
        this.refCursorPosition = refCursorPosition;
    }

    @Override
    protected void openCursor(Connection con) {
        Assert.state((this.refCursorPosition >= 0 ? 1 : 0) != 0, (String)("invalid refCursorPosition specified as " + this.refCursorPosition + "; it can't be specified as a negative number."));
        CallMetaDataContext callContext = new CallMetaDataContext();
        callContext.setAccessCallParameterMetaData(false);
        callContext.setProcedureName(this.procedureName);
        callContext.setFunction(this.function);
        callContext.initializeMetaData(this.getDataSource());
        callContext.processParameters(Arrays.asList(this.parameters));
        SqlParameter cursorParameter = callContext.createReturnResultSetParameter("cursor", this.rowMapper);
        this.callString = callContext.createCallString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Call string is: " + this.callString));
        }
        int cursorSqlType = 1111;
        if (this.function) {
            if (cursorParameter instanceof SqlOutParameter) {
                cursorSqlType = cursorParameter.getSqlType();
            }
        } else if (this.refCursorPosition > 0 && this.refCursorPosition <= this.parameters.length) {
            cursorSqlType = this.parameters[this.refCursorPosition - 1].getSqlType();
        }
        try {
            this.callableStatement = this.isUseSharedExtendedConnection() ? con.prepareCall(this.callString, 1003, 1007, 1) : con.prepareCall(this.callString, 1003, 1007);
            this.applyStatementSettings(this.callableStatement);
            if (this.preparedStatementSetter != null) {
                this.preparedStatementSetter.setValues((PreparedStatement)this.callableStatement);
            }
            if (this.function) {
                this.callableStatement.registerOutParameter(1, cursorSqlType);
            } else if (this.refCursorPosition > 0) {
                this.callableStatement.registerOutParameter(this.refCursorPosition, cursorSqlType);
            }
            boolean results = this.callableStatement.execute();
            this.rs = results ? this.callableStatement.getResultSet() : (this.function ? (ResultSet)this.callableStatement.getObject(1) : (ResultSet)this.callableStatement.getObject(this.refCursorPosition));
            this.handleWarnings(this.callableStatement);
        }
        catch (SQLException se) {
            this.close();
            throw this.translateSqlException("Executing stored procedure", this.getSql(), se);
        }
    }

    @Override
    protected @Nullable T readCursor(ResultSet rs, int currentRow) throws SQLException {
        return (T)this.rowMapper.mapRow(rs, currentRow);
    }

    @Override
    protected void cleanupOnClose(Connection connection) {
        JdbcUtils.closeStatement((Statement)this.callableStatement);
    }

    @Override
    public String getSql() {
        return this.callString != null ? this.callString : "PROCEDURE NAME: " + this.procedureName;
    }
}

