/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item;

import org.springframework.core.convert.converter.Converter;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpELItemKeyMapper<K, V>
implements Converter<V, K> {
    private final Expression parsedExpression;

    public SpELItemKeyMapper(String keyExpression) {
        this.parsedExpression = new SpelExpressionParser().parseExpression(keyExpression);
    }

    public K convert(V item) {
        Object key = this.parsedExpression.getValue(item);
        if (key == null) {
            throw new IllegalArgumentException("Derived Key is null for item = " + String.valueOf(item) + ". This item will be skipped.");
        }
        return (K)key;
    }
}

