/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.redis.builder;

import org.springframework.batch.item.redis.RedisItemWriter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisItemWriterBuilder<K, V> {
    private RedisTemplate<K, V> redisTemplate;
    private Converter<V, K> itemKeyMapper;
    private boolean delete;

    public RedisItemWriterBuilder<K, V> redisTemplate(RedisTemplate<K, V> redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public RedisItemWriterBuilder<K, V> itemKeyMapper(Converter<V, K> itemKeyMapper) {
        this.itemKeyMapper = itemKeyMapper;
        return this;
    }

    public RedisItemWriterBuilder<K, V> delete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public RedisItemWriter<K, V> build() {
        Assert.notNull(this.redisTemplate, (String)"RedisTemplate is required.");
        Assert.notNull(this.itemKeyMapper, (String)"itemKeyMapper is required.");
        RedisItemWriter<K, V> writer = new RedisItemWriter<K, V>();
        writer.setRedisTemplate(this.redisTemplate);
        writer.setItemKeyMapper(this.itemKeyMapper);
        writer.setDelete(this.delete);
        return writer;
    }
}

