/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.aop.support.AopUtils;
import org.springframework.batch.support.MethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotationMethodResolver
implements MethodResolver {
    private final Class<? extends Annotation> annotationType;

    public AnnotationMethodResolver(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, (String)"annotationType must not be null");
        Assert.isTrue((boolean)ObjectUtils.containsElement((Object[])annotationType.getAnnotation(Target.class).value(), (Object)((Object)ElementType.METHOD)), (String)("Annotation [" + annotationType + "] is not a Method-level annotation."));
        this.annotationType = annotationType;
    }

    @Override
    @Nullable
    public Method findMethod(Object candidate) {
        Assert.notNull((Object)candidate, (String)"candidate object must not be null");
        Class<?> targetClass = AopUtils.getTargetClass((Object)candidate);
        if (targetClass == null) {
            targetClass = candidate.getClass();
        }
        return this.findMethod(targetClass);
    }

    @Override
    @Nullable
    public Method findMethod(Class<?> clazz) {
        Assert.notNull(clazz, (String)"class must not be null");
        AtomicReference annotatedMethod = new AtomicReference();
        ReflectionUtils.doWithMethods(clazz, method -> {
            Annotation annotation = AnnotationUtils.findAnnotation((Method)method, this.annotationType);
            if (annotation != null) {
                Assert.isNull(annotatedMethod.get(), (String)("found more than one method on target class [" + clazz + "] with the annotation type [" + this.annotationType + "]"));
                annotatedMethod.set(method);
            }
        });
        return (Method)annotatedMethod.get();
    }
}

