/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.aop.support.AopUtils;
import org.springframework.batch.item.ItemReader;
import org.springframework.lang.Nullable;

public class ListItemReader<T>
implements ItemReader<T> {
    private List<T> list;

    public ListItemReader(List<T> list) {
        this.list = AopUtils.isAopProxy(list) ? list : new ArrayList<T>(list);
    }

    @Override
    @Nullable
    public T read() {
        if (!this.list.isEmpty()) {
            return this.list.remove(0);
        }
        return null;
    }
}

