/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TimeZone;
import org.springframework.batch.admin.domain.JobExecutionInfo;
import org.springframework.batch.admin.domain.JobInstanceInfoResource;
import org.springframework.batch.admin.web.BatchJobInstancesController;
import org.springframework.batch.admin.web.JobInstanceInfo;
import org.springframework.batch.admin.web.resource.JobExecutionInfoResourceAssembler;
import org.springframework.batch.core.JobExecution;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;

public class JobInstanceInfoResourceAssembler
extends ResourceAssemblerSupport<JobInstanceInfo, JobInstanceInfoResource> {
    JobExecutionInfoResourceAssembler jobExecutionInfoResourceAssembler = new JobExecutionInfoResourceAssembler();

    public JobInstanceInfoResourceAssembler() {
        super(BatchJobInstancesController.class, JobInstanceInfoResource.class);
    }

    public JobInstanceInfoResource toResource(JobInstanceInfo entity) {
        return (JobInstanceInfoResource)this.createResourceWithId(entity.getJobInstance().getId(), entity);
    }

    protected JobInstanceInfoResource instantiateResource(JobInstanceInfo entity) {
        Collection<JobExecution> jobExecutions = entity.getJobExecutions();
        ArrayList<JobExecutionInfo> infos = new ArrayList<JobExecutionInfo>(jobExecutions.size());
        for (JobExecution jobExecution : jobExecutions) {
            infos.add(new JobExecutionInfo(jobExecution, TimeZone.getTimeZone("UTC")));
        }
        return new JobInstanceInfoResource(entity.getJobInstance(), this.jobExecutionInfoResourceAssembler.toResources(infos));
    }
}

