/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web.resource;

import java.util.ArrayList;
import org.springframework.batch.admin.domain.JobExecutionInfo;
import org.springframework.batch.admin.domain.JobExecutionInfoResource;
import org.springframework.batch.admin.domain.StepExecutionInfo;
import org.springframework.batch.admin.domain.StepExecutionInfoResource;
import org.springframework.batch.admin.web.BatchJobExecutionsController;
import org.springframework.batch.admin.web.resource.StepExecutionInfoResourceAssembler;
import org.springframework.batch.core.StepExecution;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;

public class JobExecutionInfoResourceAssembler
extends ResourceAssemblerSupport<JobExecutionInfo, JobExecutionInfoResource> {
    private StepExecutionInfoResourceAssembler stepExecutionInfoResourceAssembler = new StepExecutionInfoResourceAssembler();

    public JobExecutionInfoResourceAssembler() {
        super(BatchJobExecutionsController.class, JobExecutionInfoResource.class);
    }

    public JobExecutionInfoResource toResource(JobExecutionInfo entity) {
        return (JobExecutionInfoResource)this.createResourceWithId(entity.getJobExecution().getId(), entity);
    }

    protected JobExecutionInfoResource instantiateResource(JobExecutionInfo entity) {
        ArrayList<StepExecutionInfoResource> stepExecutionInfoResources = new ArrayList<StepExecutionInfoResource>(entity.getStepExecutionCount());
        if (entity.getStepExecutionCount() > 0) {
            for (StepExecution stepExecution : entity.getJobExecution().getStepExecutions()) {
                stepExecutionInfoResources.add(this.stepExecutionInfoResourceAssembler.toResource(new StepExecutionInfo(stepExecution, entity.getTimeZone())));
            }
        }
        JobExecutionInfoResource jobExecutionInfoResource = new JobExecutionInfoResource(entity.getJobExecution(), entity.getTimeZone());
        jobExecutionInfoResource.setStepExecutions(stepExecutionInfoResources);
        return jobExecutionInfoResource;
    }
}

