/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.JobParameter;

public class JobParameterJacksonDeserializer
extends JsonDeserializer<JobParameter> {
    private static Log logger = LogFactory.getLog(JobParameterJacksonDeserializer.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JobParameter deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JobParameter jobParameter;
        SimpleDateFormat formatter = new SimpleDateFormat();
        ObjectCodec oc = jsonParser.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jsonParser);
        String value = node.get("value").asText();
        boolean identifying = node.get("identifying").asBoolean();
        String type = node.get("type").asText();
        if (!type.isEmpty() && !type.equalsIgnoreCase("STRING")) {
            if ("DATE".equalsIgnoreCase(type)) {
                try {
                    jobParameter = new JobParameter(formatter.parse(value), identifying);
                }
                catch (ParseException e) {
                    throw new IOException(e);
                }
            } else if ("DOUBLE".equalsIgnoreCase(type)) {
                jobParameter = new JobParameter(Double.valueOf(value), identifying);
            } else {
                if (!"LONG".equalsIgnoreCase(type)) throw new IllegalStateException("Unsupported JobParameter type: " + type);
                jobParameter = new JobParameter(Long.valueOf(value), identifying);
            }
        } else {
            jobParameter = new JobParameter(value, identifying);
        }
        if (!logger.isDebugEnabled()) return jobParameter;
        logger.debug((Object)String.format("jobParameter - value: %s (type: %s, isIdentifying: %s)", jobParameter.getValue(), jobParameter.getType().name(), jobParameter.isIdentifying()));
        return jobParameter;
    }
}

