/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain;

import java.util.Date;
import java.util.TimeZone;
import org.springframework.batch.admin.domain.CumulativeHistory;
import org.springframework.batch.admin.domain.StepExecutionHistory;
import org.springframework.batch.core.StepExecution;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.StringUtils;

public class StepExecutionProgressInfo {
    private final StepExecution stepExecution;
    private final StepExecutionHistory stepExecutionHistory;
    private double duration = 0.0;
    private double percentageComplete = 0.5;
    private boolean isFinished = false;
    private PercentCompleteBasis percentCompleteBasis = PercentCompleteBasis.UNKNOWN;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");

    public StepExecutionProgressInfo(StepExecution stepExecution, StepExecutionHistory stepExecutionHistory, TimeZone timeZone) {
        this(stepExecution, stepExecutionHistory);
        if (timeZone != null) {
            timeZone = this.timeZone;
        }
    }

    public StepExecutionProgressInfo(StepExecution stepExecution, StepExecutionHistory stepExecutionHistory) {
        this.stepExecution = stepExecution;
        this.stepExecutionHistory = stepExecutionHistory;
        Date startTime = stepExecution.getStartTime();
        Date endTime = stepExecution.getEndTime();
        if (endTime == null) {
            endTime = new Date();
        } else {
            this.isFinished = true;
        }
        if (startTime == null) {
            startTime = new Date();
        }
        this.duration = endTime.getTime() - startTime.getTime();
        this.percentageComplete = this.calculatePercentageComplete();
    }

    public MessageSourceResolvable getEstimatedPercentCompleteMessage() {
        String defaultMessage = String.format("This execution is estimated to be %.0f%% complete after %.0f ms based on %s", this.percentageComplete * 100.0, this.duration, this.percentCompleteBasis.getMessage().getDefaultMessage());
        DefaultMessageSourceResolvable message = new DefaultMessageSourceResolvable(new String[]{"step.execution.estimated.progress"}, new Object[]{this.percentageComplete, this.duration, this.percentCompleteBasis.getMessage()}, defaultMessage);
        return message;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public double getDuration() {
        return this.duration;
    }

    public double getEstimatedPercentComplete() {
        return this.percentageComplete;
    }

    private double calculatePercentageComplete() {
        if (this.isFinished) {
            this.percentCompleteBasis = PercentCompleteBasis.ENDTIME;
            return 1.0;
        }
        if (this.stepExecutionHistory.getCount() == 0) {
            this.percentCompleteBasis = PercentCompleteBasis.NOHISTORY;
            return 0.5;
        }
        CumulativeHistory readHistory = this.stepExecutionHistory.getReadCount();
        if (readHistory.getMean() == 0.0) {
            this.percentCompleteBasis = PercentCompleteBasis.DURATION;
            return this.getDurationBasedEstimate(this.duration);
        }
        this.percentCompleteBasis = PercentCompleteBasis.READCOUNT;
        return (double)this.stepExecution.getReadCount() / readHistory.getMean();
    }

    private double getDurationBasedEstimate(double duration) {
        CumulativeHistory durationHistory = this.stepExecutionHistory.getDuration();
        if (durationHistory.getMean() == 0.0) {
            this.percentCompleteBasis = PercentCompleteBasis.NOINFORMATION;
            return 0.5;
        }
        return duration / durationHistory.getMean();
    }

    public Long getStepExecutionId() {
        return this.stepExecution.getId();
    }

    public StepExecution getStepExecution() {
        return this.stepExecution;
    }

    public StepExecutionHistory getStepExecutionHistory() {
        return this.stepExecutionHistory;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    private static enum PercentCompleteBasis {
        UNKNOWN("unknown"),
        NOINFORMATION("percent.no.information,no.information", "no information"),
        ENDTIME("percent.end.time,end.time", "end time (already finished)"),
        DURATION("percent.duration,duration", "extrapolated duration"),
        READCOUNT("percent.read.count,read.count", "extrapolated read count"),
        NOHISTORY("percent.no.history,no.history", "no history");

        private final String[] codes;
        private final String message;

        private PercentCompleteBasis(String code) {
            this(code, code);
        }

        private PercentCompleteBasis(String codes, String message) {
            this(StringUtils.commaDelimitedListToStringArray((String)codes), message);
        }

        private PercentCompleteBasis(String[] code, String message) {
            this.codes = code;
            this.message = message;
        }

        public MessageSourceResolvable getMessage() {
            return new DefaultMessageSourceResolvable(this.codes, this.message);
        }
    }
}

