/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.batch.admin.domain.StepType;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;

public class StepExecutionInfo {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private SimpleDateFormat durationFormat = new SimpleDateFormat("HH:mm:ss");
    private Long id;
    private Long jobExecutionId;
    private String jobName;
    private String name;
    private String startDate = "-";
    private String startTime = "-";
    private String duration = "-";
    private StepExecution stepExecution;
    private long durationMillis;
    private String stepType = StepType.UNKNOWN.getDisplayName();
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");

    public StepExecutionInfo(String jobName, Long jobExecutionId, String name, TimeZone timeZone) {
        this.jobName = jobName;
        this.jobExecutionId = jobExecutionId;
        this.name = name;
        this.stepExecution = new StepExecution(name, new JobExecution(jobExecutionId));
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
    }

    public StepExecutionInfo(StepExecution stepExecution, TimeZone timeZone) {
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
        this.stepExecution = stepExecution;
        this.id = stepExecution.getId();
        this.name = stepExecution.getStepName();
        this.jobName = stepExecution.getJobExecution() == null || stepExecution.getJobExecution().getJobInstance() == null ? "?" : stepExecution.getJobExecution().getJobInstance().getJobName();
        this.jobExecutionId = stepExecution.getJobExecutionId();
        this.durationFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.timeFormat.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
        if (stepExecution.getStartTime() != null) {
            this.startDate = this.dateFormat.format(stepExecution.getStartTime());
            this.startTime = this.timeFormat.format(stepExecution.getStartTime());
            Date endTime = stepExecution.getEndTime() != null ? stepExecution.getEndTime() : new Date();
            this.durationMillis = endTime.getTime() - stepExecution.getStartTime().getTime();
            this.duration = this.durationFormat.format(new Date(this.durationMillis));
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public String getName() {
        return this.name;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public String getStatus() {
        if (this.id != null) {
            return this.stepExecution.getStatus().toString();
        }
        return "NONE";
    }

    public String getExitCode() {
        if (this.id != null) {
            return this.stepExecution.getExitStatus().getExitCode();
        }
        return "NONE";
    }

    public StepExecution getStepExecution() {
        return this.stepExecution;
    }

    public String getStepType() {
        return this.stepType;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }
}

