/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain;

public class JobInfo {
    private final String name;
    private final int executionCount;
    private boolean launchable = false;
    private boolean incrementable = false;
    private final Long jobInstanceId;

    public JobInfo(String name, int executionCount) {
        this(name, executionCount, false);
    }

    public JobInfo(String name, int executionCount, boolean launchable) {
        this(name, executionCount, null, launchable, false);
    }

    public JobInfo(String name, int executionCount, boolean launchable, boolean incrementable) {
        this(name, executionCount, null, launchable, incrementable);
    }

    public JobInfo(String name, int executionCount, Long jobInstanceId, boolean launchable, boolean incrementable) {
        this.name = name;
        this.executionCount = executionCount;
        this.jobInstanceId = jobInstanceId;
        this.launchable = launchable;
        this.incrementable = incrementable;
    }

    public String getName() {
        return this.name;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    public Long getJobInstanceId() {
        return this.jobInstanceId;
    }

    public boolean isLaunchable() {
        return this.launchable;
    }

    public boolean isIncrementable() {
        return this.incrementable;
    }

    public String toString() {
        return this.name;
    }
}

