/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.batch.admin.domain.StepExecutionInfoResource;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;

@XmlRootElement
public class JobExecutionInfoResource
extends ResourceSupport {
    private DateTimeFormatter dateFormat = ISODateTimeFormat.dateTime();
    private Long executionId;
    private int stepExecutionCount;
    private Long jobId;
    private Integer version;
    @JsonProperty(value="name")
    private String jobName;
    private String startTime = "";
    private String endTime = "";
    private String createDate = "";
    private String lastUpdated = "";
    private JobParameters jobParameters;
    private boolean restartable = false;
    private boolean abandonable = false;
    private boolean stoppable = false;
    private final TimeZone timeZone;
    private BatchStatus status;
    private ExitStatus exitStatus;
    private String jobConfigurationName;
    private List<Throwable> failureExceptions;
    private Map<String, Object> executionContext;
    private Collection<StepExecutionInfoResource> stepExecutions;

    public JobExecutionInfoResource() {
        this.timeZone = TimeZone.getTimeZone("UTC");
    }

    public JobExecutionInfoResource(JobExecution jobExecution, TimeZone timeZone) {
        this.timeZone = timeZone != null ? timeZone : TimeZone.getTimeZone("UTC");
        this.executionId = jobExecution.getId();
        this.jobId = jobExecution.getJobId();
        this.stepExecutionCount = jobExecution.getStepExecutions().size();
        this.jobParameters = jobExecution.getJobParameters();
        this.status = jobExecution.getStatus();
        this.exitStatus = jobExecution.getExitStatus();
        this.jobConfigurationName = jobExecution.getJobConfigurationName();
        this.failureExceptions = jobExecution.getFailureExceptions();
        HashMap<String, Object> executionContextEntires = new HashMap<String, Object>(jobExecution.getExecutionContext().size());
        for (Map.Entry stringObjectEntry : jobExecution.getExecutionContext().entrySet()) {
            executionContextEntires.put((String)stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
        this.executionContext = executionContextEntires;
        this.version = jobExecution.getVersion();
        JobInstance jobInstance = jobExecution.getJobInstance();
        if (jobInstance != null) {
            this.jobName = jobInstance.getJobName();
            BatchStatus status = jobExecution.getStatus();
            this.restartable = status.isGreaterThan(BatchStatus.STOPPING) && status.isLessThan(BatchStatus.ABANDONED);
            this.abandonable = status.isGreaterThan(BatchStatus.STARTED) && status != BatchStatus.ABANDONED;
            this.stoppable = status.isLessThan(BatchStatus.STOPPING) && status != BatchStatus.COMPLETED;
        } else {
            this.jobName = "?";
        }
        this.dateFormat = this.dateFormat.withZone(DateTimeZone.forTimeZone((TimeZone)timeZone));
        this.createDate = this.dateFormat.print(jobExecution.getCreateTime().getTime());
        this.lastUpdated = this.dateFormat.print(jobExecution.getLastUpdated().getTime());
        if (jobExecution.getStartTime() != null) {
            this.startTime = this.dateFormat.print(jobExecution.getStartTime().getTime());
            this.endTime = this.dateFormat.print(jobExecution.getEndTime().getTime());
        }
    }

    public void setStepExecutions(Collection<StepExecutionInfoResource> stepExecutions) {
        this.stepExecutions = stepExecutions;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public String getName() {
        return this.jobName.endsWith(".job") ? this.jobName.substring(0, this.jobName.lastIndexOf(".job")) : this.jobName;
    }

    public Long getExecutionId() {
        return this.executionId;
    }

    public int getStepExecutionCount() {
        return this.stepExecutionCount;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public boolean isStoppable() {
        return this.stoppable;
    }

    public JobParameters getJobParameters() {
        return this.jobParameters;
    }

    public Map<String, Object> getExecutionContext() {
        return this.executionContext;
    }

    public List<Throwable> getFailureExceptions() {
        return this.failureExceptions;
    }

    public String getJobConfigurationName() {
        return this.jobConfigurationName;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public Collection<StepExecutionInfoResource> getStepExecutions() {
        return this.stepExecutions;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public static class Page
    extends PagedResources<JobExecutionInfoResource> {
    }
}

