/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.domain;

public class CumulativeHistory {
    private int count;
    private double sum;
    private double sumSquares;
    private double min;
    private double max;

    public void append(double value) {
        if (value > this.max || this.count == 0) {
            this.max = value;
        }
        if (value < this.min || this.count == 0) {
            this.min = value;
        }
        this.sum += value;
        this.sumSquares += value * value;
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }

    public double getMean() {
        return this.count > 0 ? this.sum / (double)this.count : 0.0;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        return this.count > 0 ? Math.sqrt(this.sumSquares / (double)this.count - mean * mean) : 0.0;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public String toString() {
        return String.format("[N=%d, min=%f, max=%f, mean=%f, sigma=%f]", this.count, this.min, this.max, this.getMean(), this.getStandardDeviation());
    }
}

