/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

public class ContentCodingType
implements Comparable<ContentCodingType> {
    public static final ContentCodingType ALL;
    public static final String ALL_VALUE = "*";
    public static final ContentCodingType IDENTITY;
    public static final String IDENTITY_VALUE = "identity";
    public static final ContentCodingType GZIP;
    public static final String GZIP_VALUE = "gzip";
    private static final BitSet TOKEN;
    private static final String WILDCARD_TYPE = "*";
    private static final String PARAM_QUALITY_FACTOR = "q";
    private final String type;
    private final Map<String, String> parameters;
    public static final Comparator<ContentCodingType> QUALITY_VALUE_COMPARATOR;

    public ContentCodingType(String type) {
        this(type, Collections.emptyMap());
    }

    public ContentCodingType(String type, double qualityValue) {
        this(type, Collections.singletonMap(PARAM_QUALITY_FACTOR, Double.toString(qualityValue)));
    }

    public ContentCodingType(String type, Map<String, String> parameters) {
        Assert.hasLength((String)type, (String)"'type' must not be empty");
        this.checkToken(type);
        this.type = type.toLowerCase(Locale.ENGLISH);
        if (!CollectionUtils.isEmpty(parameters)) {
            LinkedCaseInsensitiveMap m = new LinkedCaseInsensitiveMap(parameters.size(), Locale.ENGLISH);
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String attribute = entry.getKey();
                String value = entry.getValue();
                this.checkParameters(attribute, value);
                m.put(attribute, this.unquote(value));
            }
            this.parameters = Collections.unmodifiableMap(m);
        } else {
            this.parameters = Collections.emptyMap();
        }
    }

    private void checkToken(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (TOKEN.get(ch)) continue;
            throw new IllegalArgumentException("Invalid token character '" + ch + "' in token \"" + s + "\"");
        }
    }

    private void checkParameters(String attribute, String value) {
        Assert.hasLength((String)attribute, (String)"parameter attribute must not be empty");
        Assert.hasLength((String)value, (String)"parameter value must not be empty");
        this.checkToken(attribute);
        if (PARAM_QUALITY_FACTOR.equals(attribute)) {
            double d = Double.parseDouble(value = this.unquote(value));
            Assert.isTrue((d >= 0.0 && d <= 1.0 ? 1 : 0) != 0, (String)("Invalid quality value \"" + value + "\": should be between 0.0 and 1.0"));
        } else if (!this.isQuotedString(value)) {
            this.checkToken(value);
        }
    }

    private boolean isQuotedString(String s) {
        return s.length() > 1 && s.startsWith("\"") && s.endsWith("\"");
    }

    private String unquote(String s) {
        if (s == null) {
            return null;
        }
        return this.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return "*".equals(this.type);
    }

    public double getQualityValue() {
        String qualityFactory = this.getParameter(PARAM_QUALITY_FACTOR);
        return qualityFactory != null ? Double.parseDouble(qualityFactory) : 1.0;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public boolean includes(ContentCodingType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType()) {
            return true;
        }
        return this.type.equals(other.type);
    }

    public boolean isCompatibleWith(ContentCodingType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType() || other.isWildcardType()) {
            return true;
        }
        return this.type.equals(other.type);
    }

    @Override
    public int compareTo(ContentCodingType other) {
        int comp = this.type.compareToIgnoreCase(other.type);
        if (comp != 0) {
            return comp;
        }
        comp = this.parameters.size() - other.parameters.size();
        if (comp != 0) {
            return comp;
        }
        TreeSet<String> thisAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        thisAttributes.addAll(this.parameters.keySet());
        TreeSet<String> otherAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        otherAttributes.addAll(other.parameters.keySet());
        Iterator thisAttributesIterator = thisAttributes.iterator();
        Iterator otherAttributesIterator = otherAttributes.iterator();
        while (thisAttributesIterator.hasNext()) {
            String otherAttribute;
            String thisAttribute = (String)thisAttributesIterator.next();
            comp = thisAttribute.compareToIgnoreCase(otherAttribute = (String)otherAttributesIterator.next());
            if (comp != 0) {
                return comp;
            }
            String thisValue = this.parameters.get(thisAttribute);
            String otherValue = other.parameters.get(otherAttribute);
            if (otherValue == null) {
                otherValue = "";
            }
            if ((comp = thisValue.compareTo(otherValue)) == 0) continue;
            return comp;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentCodingType)) {
            return false;
        }
        ContentCodingType otherType = (ContentCodingType)other;
        return this.type.equalsIgnoreCase(otherType.type) && this.parameters.equals(otherType.parameters);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    private void appendTo(StringBuilder builder) {
        builder.append(this.type);
        this.appendTo(this.parameters, builder);
    }

    private void appendTo(Map<String, String> map, StringBuilder builder) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(';');
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
    }

    public static ContentCodingType valueOf(String value) {
        return ContentCodingType.parseCodingType(value);
    }

    public static ContentCodingType parseCodingType(String codingType) {
        Assert.hasLength((String)codingType, (String)"'codingType' must not be empty");
        String[] parts = StringUtils.tokenizeToStringArray((String)codingType, (String)";");
        String type = parts[0].trim();
        LinkedHashMap<String, String> parameters = null;
        if (parts.length > 1) {
            parameters = new LinkedHashMap<String, String>(parts.length - 1);
            for (int i = 1; i < parts.length; ++i) {
                String parameter = parts[i];
                int eqIndex = parameter.indexOf(61);
                if (eqIndex == -1) continue;
                String attribute = parameter.substring(0, eqIndex);
                String value = parameter.substring(eqIndex + 1, parameter.length());
                parameters.put(attribute, value);
            }
        }
        return new ContentCodingType(type, parameters);
    }

    public static List<ContentCodingType> parseCodingTypes(String codingTypes) {
        if (!StringUtils.hasLength((String)codingTypes)) {
            return Collections.emptyList();
        }
        String[] tokens = codingTypes.split(",");
        ArrayList<ContentCodingType> result = new ArrayList<ContentCodingType>(tokens.length);
        for (String token : tokens) {
            result.add(ContentCodingType.parseCodingType(token));
        }
        return result;
    }

    public static String toString(Collection<ContentCodingType> codingTypes) {
        StringBuilder builder = new StringBuilder();
        Iterator<ContentCodingType> iterator = codingTypes.iterator();
        while (iterator.hasNext()) {
            ContentCodingType codingType = iterator.next();
            codingType.appendTo(builder);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static void sortByQualityValue(List<ContentCodingType> codingTypes) {
        Assert.notNull(codingTypes, (String)"'codingTypes' must not be null");
        if (codingTypes.size() > 1) {
            Collections.sort(codingTypes, QUALITY_VALUE_COMPARATOR);
        }
    }

    static {
        BitSet ctl = new BitSet(128);
        for (int i = 0; i <= 31; ++i) {
            ctl.set(i);
        }
        ctl.set(127);
        BitSet separators = new BitSet(128);
        separators.set(40);
        separators.set(41);
        separators.set(60);
        separators.set(62);
        separators.set(64);
        separators.set(44);
        separators.set(59);
        separators.set(58);
        separators.set(92);
        separators.set(34);
        separators.set(47);
        separators.set(91);
        separators.set(93);
        separators.set(63);
        separators.set(61);
        separators.set(123);
        separators.set(125);
        separators.set(32);
        separators.set(9);
        TOKEN = new BitSet(128);
        TOKEN.set(0, 128);
        TOKEN.andNot(ctl);
        TOKEN.andNot(separators);
        ALL = ContentCodingType.valueOf("*");
        IDENTITY = ContentCodingType.valueOf(IDENTITY_VALUE);
        GZIP = ContentCodingType.valueOf(GZIP_VALUE);
        QUALITY_VALUE_COMPARATOR = new Comparator<ContentCodingType>(){

            @Override
            public int compare(ContentCodingType codingType1, ContentCodingType codingType2) {
                double quality1 = codingType1.getQualityValue();
                double quality2 = codingType2.getQualityValue();
                int qualityComparison = Double.compare(quality2, quality1);
                if (qualityComparison != 0) {
                    return qualityComparison;
                }
                if (codingType1.isWildcardType() && !codingType2.isWildcardType()) {
                    return 1;
                }
                if (codingType2.isWildcardType() && !codingType1.isWildcardType()) {
                    return -1;
                }
                if (!codingType1.getType().equals(codingType2.getType())) {
                    return 0;
                }
                return 0;
            }
        };
    }
}

