/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.retry;

import org.springframework.analytics.retry.RedisRetryTemplate;
import org.springframework.data.redis.connection.DefaultStringRedisConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.retry.RetryOperations;

public class StringRedisRetryTemplate
extends RedisRetryTemplate<String, String> {
    public StringRedisRetryTemplate(RedisConnectionFactory connectionFactory, RetryOperations retryOperations) {
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        this.setKeySerializer((RedisSerializer)stringSerializer);
        this.setValueSerializer((RedisSerializer)stringSerializer);
        this.setHashKeySerializer((RedisSerializer)stringSerializer);
        this.setHashValueSerializer((RedisSerializer)stringSerializer);
        this.setRetryOperations(retryOperations);
        this.setConnectionFactory(connectionFactory);
        this.afterPropertiesSet();
    }

    protected RedisConnection preProcessConnection(RedisConnection connection, boolean existingConnection) {
        return new DefaultStringRedisConnection(connection);
    }
}

