/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultMessagePropertiesConverter
implements MessagePropertiesConverter {
    private static final int DEFAULT_LONG_STRING_LIMIT = 1024;
    private final int longStringLimit;
    private final boolean convertLongLongStrings;

    public DefaultMessagePropertiesConverter() {
        this(1024, false);
    }

    public DefaultMessagePropertiesConverter(int longStringLimit) {
        this(longStringLimit, false);
    }

    public DefaultMessagePropertiesConverter(int longStringLimit, boolean convertLongLongStrings) {
        this.longStringLimit = longStringLimit;
        this.convertLongLongStrings = convertLongLongStrings;
    }

    @Override
    public MessageProperties toMessageProperties(AMQP.BasicProperties source, @Nullable Envelope envelope, String charset) {
        Object value;
        List xDeathHeader;
        String replyTo;
        MessageProperties target = new MessageProperties();
        Map headers = source.getHeaders();
        if (!CollectionUtils.isEmpty((Map)headers)) {
            for (Map.Entry entry : headers.entrySet()) {
                Number numberValue;
                Object value2;
                String key = (String)entry.getKey();
                if ("x-delay".equals(key)) {
                    value2 = entry.getValue();
                    if (!(value2 instanceof Number)) continue;
                    numberValue = (Number)value2;
                    long receivedDelayLongValue = Math.abs(numberValue.longValue());
                    target.setReceivedDelayLong(Long.valueOf(receivedDelayLongValue));
                    target.setHeader(key, (Object)receivedDelayLongValue);
                    continue;
                }
                if ("retry-count".equals(key)) {
                    value2 = entry.getValue();
                    if (!(value2 instanceof Number)) continue;
                    numberValue = (Number)value2;
                    target.setRetryCount(numberValue.longValue());
                    continue;
                }
                target.setHeader(key, this.convertLongStringIfNecessary(entry.getValue(), charset));
            }
        }
        target.setTimestamp(source.getTimestamp());
        target.setMessageId(source.getMessageId());
        target.setReceivedUserId(source.getUserId());
        target.setAppId(source.getAppId());
        target.setClusterId(source.getClusterId());
        target.setType(source.getType());
        Integer deliveryMode = source.getDeliveryMode();
        if (deliveryMode != null) {
            target.setReceivedDeliveryMode(MessageDeliveryMode.fromInt((int)deliveryMode));
        }
        target.setDeliveryMode(null);
        target.setExpiration(source.getExpiration());
        target.setPriority(source.getPriority());
        target.setContentType(source.getContentType());
        target.setContentEncoding(source.getContentEncoding());
        String correlationId = source.getCorrelationId();
        if (StringUtils.hasText((String)correlationId)) {
            target.setCorrelationId(source.getCorrelationId());
        }
        if ((replyTo = source.getReplyTo()) != null) {
            target.setReplyTo(replyTo);
        }
        if (envelope != null) {
            target.setReceivedExchange(envelope.getExchange());
            target.setReceivedRoutingKey(envelope.getRoutingKey());
            target.setRedelivered(Boolean.valueOf(envelope.isRedeliver()));
            target.setDeliveryTag(envelope.getDeliveryTag());
        }
        if (target.getRetryCount() == 0L && !CollectionUtils.isEmpty((Collection)(xDeathHeader = target.getXDeathHeader())) && (value = ((Map)xDeathHeader.get(0)).get("count")) instanceof Number) {
            Number numberValue = (Number)value;
            target.setRetryCount(numberValue.longValue());
        }
        return target;
    }

    @Override
    public AMQP.BasicProperties fromMessageProperties(MessageProperties source, String charset) {
        String replyTo;
        AMQP.BasicProperties.Builder target = new AMQP.BasicProperties.Builder();
        Map<String, Object> headers = this.convertHeadersIfNecessary(source);
        target.headers(headers).timestamp(source.getTimestamp()).messageId(source.getMessageId()).userId(source.getUserId()).appId(source.getAppId()).clusterId(source.getClusterId()).type(source.getType());
        MessageDeliveryMode deliveryMode = source.getDeliveryMode();
        if (deliveryMode != null) {
            target.deliveryMode(Integer.valueOf(MessageDeliveryMode.toInt((MessageDeliveryMode)deliveryMode)));
        }
        target.expiration(source.getExpiration()).priority(source.getPriority()).contentType(source.getContentType()).contentEncoding(source.getContentEncoding());
        String correlationId = source.getCorrelationId();
        if (StringUtils.hasText((String)correlationId)) {
            target.correlationId(correlationId);
        }
        if ((replyTo = source.getReplyTo()) != null) {
            target.replyTo(replyTo);
        }
        return target.build();
    }

    private Map<String, Object> convertHeadersIfNecessary(MessageProperties source) {
        Map headers = source.getHeaders();
        long retryCount = source.getRetryCount();
        if (CollectionUtils.isEmpty((Map)headers) && retryCount == 0L) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> writableHeaders = new HashMap<String, Object>();
        for (Map.Entry entry : headers.entrySet()) {
            writableHeaders.put((String)entry.getKey(), this.convertHeaderValueIfNecessary(entry.getValue()));
        }
        if (retryCount > 0L) {
            writableHeaders.put("retry-count", retryCount);
        }
        return writableHeaders;
    }

    @Nullable
    private Object convertHeaderValueIfNecessary(@Nullable Object valueArg) {
        boolean valid;
        Object value = valueArg;
        boolean bl = valid = value instanceof String || value instanceof byte[] || value instanceof Boolean || value instanceof Class || value instanceof LongString || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof Short || value instanceof Byte || value instanceof Date || value instanceof List || value instanceof Map || value instanceof Object[];
        if (!valid && value != null) {
            value = value.toString();
        } else if (value instanceof Object[]) {
            Object[] array = value;
            Object[] writableArray = new Object[array.length];
            for (int i = 0; i < writableArray.length; ++i) {
                writableArray[i] = this.convertHeaderValueIfNecessary(array[i]);
            }
            value = writableArray;
        } else if (value instanceof List) {
            List values = (List)value;
            ArrayList<Object> writableList = new ArrayList<Object>(values.size());
            for (Object listValue : values) {
                writableList.add(this.convertHeaderValueIfNecessary(listValue));
            }
            value = writableList;
        } else if (value instanceof Map) {
            Map originalMap = (Map)value;
            HashMap<String, Object> writableMap = new HashMap<String, Object>(originalMap.size());
            for (Map.Entry entry : originalMap.entrySet()) {
                writableMap.put((String)entry.getKey(), this.convertHeaderValueIfNecessary(entry.getValue()));
            }
            value = writableMap;
        } else if (value instanceof Class) {
            Class clazz = (Class)value;
            value = clazz.getName();
        }
        return value;
    }

    private Object convertLongString(LongString longString, String charset) {
        try {
            if (longString.length() <= (long)this.longStringLimit) {
                return new String(longString.getBytes(), charset);
            }
            return this.convertLongLongStrings ? longString.getStream() : longString;
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    private Object convertLongStringIfNecessary(Object valueArg, String charset) {
        if (valueArg instanceof LongString) {
            LongString longStr = (LongString)valueArg;
            return this.convertLongString(longStr, charset);
        }
        if (valueArg instanceof List) {
            List values = (List)valueArg;
            ArrayList convertedList = new ArrayList(values.size());
            values.forEach(value -> convertedList.add(this.convertLongStringIfNecessary(value, charset)));
            return convertedList;
        }
        if (valueArg instanceof Map) {
            Map originalMap = (Map)valueArg;
            HashMap convertedMap = new HashMap();
            originalMap.forEach((key, value) -> convertedMap.put((String)key, this.convertLongStringIfNecessary(value, charset)));
            return convertedMap;
        }
        return valueArg;
    }
}

