/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.PossibleAuthenticationFailureException;
import com.rabbitmq.client.ShutdownSignalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpConnectException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.BatchMessageListener;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.batch.BatchingStrategy;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.ConsumerChannelRegistry;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.SimpleResourceHolder;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.AsyncConsumerRestartedEvent;
import org.springframework.amqp.rabbit.listener.AsyncConsumerStartedEvent;
import org.springframework.amqp.rabbit.listener.AsyncConsumerStoppedEvent;
import org.springframework.amqp.rabbit.listener.BlockingQueueConsumer;
import org.springframework.amqp.rabbit.listener.ListenerContainerConsumerFailedEvent;
import org.springframework.amqp.rabbit.listener.QueuesNotAvailableException;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareBatchMessageListener;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerExecutionException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerStartupException;
import org.springframework.amqp.rabbit.support.ActiveObjectCounter;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.amqp.rabbit.support.ListenerContainerAware;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.log.LogMessage;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.support.MetricType;
import org.springframework.lang.Nullable;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOffExecution;

public class SimpleMessageListenerContainer
extends AbstractMessageListenerContainer {
    private static final int RECOVERY_LOOP_WAIT_TIME = 200;
    private static final long DEFAULT_START_CONSUMER_MIN_INTERVAL = 10000L;
    private static final long DEFAULT_STOP_CONSUMER_MIN_INTERVAL = 60000L;
    private static final long DEFAULT_CONSUMER_START_TIMEOUT = 60000L;
    private static final int DEFAULT_CONSECUTIVE_ACTIVE_TRIGGER = 10;
    private static final int DEFAULT_CONSECUTIVE_IDLE_TRIGGER = 10;
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    private final AtomicLong lastNoMessageAlert = new AtomicLong();
    private final AtomicReference<Thread> containerStoppingForAbort = new AtomicReference();
    private final BlockingQueue<ListenerContainerConsumerFailedEvent> abortEvents = new LinkedBlockingQueue<ListenerContainerConsumerFailedEvent>();
    private final ActiveObjectCounter<BlockingQueueConsumer> cancellationLock = new ActiveObjectCounter();
    private long startConsumerMinInterval = 10000L;
    private long stopConsumerMinInterval = 60000L;
    private int consecutiveActiveTrigger = 10;
    private int consecutiveIdleTrigger = 10;
    private int batchSize = 1;
    private boolean consumerBatchEnabled;
    private long receiveTimeout = 1000L;
    private long batchReceiveTimeout;
    private Set<BlockingQueueConsumer> consumers;
    private Integer declarationRetries;
    private Long retryDeclarationInterval;
    private TransactionTemplate transactionTemplate;
    private long consumerStartTimeout = 60000L;
    private boolean enforceImmediateAckForManual;
    private volatile int concurrentConsumers = 1;
    private volatile Integer maxConcurrentConsumers;
    private volatile long lastConsumerStarted;
    private volatile long lastConsumerStopped;

    public SimpleMessageListenerContainer() {
    }

    public SimpleMessageListenerContainer(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue((concurrentConsumers > 0 ? 1 : 0) != 0, (String)"'concurrentConsumers' value must be at least 1 (one)");
        Assert.isTrue((!this.isExclusive() || concurrentConsumers == 1 ? 1 : 0) != 0, (String)"When the consumer is exclusive, the concurrency must be 1");
        if (this.maxConcurrentConsumers != null) {
            Assert.isTrue((concurrentConsumers <= this.maxConcurrentConsumers ? 1 : 0) != 0, (String)"'concurrentConsumers' cannot be more than 'maxConcurrentConsumers'");
        }
        this.consumersLock.lock();
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Changing consumers from " + this.concurrentConsumers + " to " + concurrentConsumers));
            }
            int delta = this.concurrentConsumers - concurrentConsumers;
            this.concurrentConsumers = concurrentConsumers;
            if (this.isActive()) {
                this.adjustConsumers(delta);
            }
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        int delta;
        Assert.isTrue((maxConcurrentConsumers >= this.concurrentConsumers ? 1 : 0) != 0, (String)"'maxConcurrentConsumers' value must be at least 'concurrentConsumers'");
        Assert.isTrue((!this.isExclusive() || maxConcurrentConsumers == 1 ? 1 : 0) != 0, (String)"When the consumer is exclusive, the concurrency must be 1");
        Integer oldMax = this.maxConcurrentConsumers;
        this.maxConcurrentConsumers = maxConcurrentConsumers;
        if (oldMax != null && this.isActive() && (delta = oldMax - maxConcurrentConsumers) > 0) {
            this.adjustConsumers(delta);
        }
    }

    public void setConcurrency(String concurrency) {
        try {
            int separatorIndex = concurrency.indexOf(45);
            if (separatorIndex != -1) {
                int consumersToSet = Integer.parseInt(concurrency.substring(0, separatorIndex));
                int maxConsumersToSet = Integer.parseInt(concurrency.substring(separatorIndex + 1));
                Assert.isTrue((maxConsumersToSet >= consumersToSet ? 1 : 0) != 0, (String)"'maxConcurrentConsumers' value must be at least 'concurrentConsumers'");
                this.maxConcurrentConsumers = null;
                this.setConcurrentConsumers(consumersToSet);
                this.setMaxConcurrentConsumers(maxConsumersToSet);
            } else {
                this.setConcurrentConsumers(Integer.parseInt(concurrency));
            }
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid concurrency value [" + concurrency + "]: only single fixed integer (e.g. \"5\") and minimum-maximum combo (e.g. \"3-5\") supported.", ex);
        }
    }

    @Override
    public final void setExclusive(boolean exclusive) {
        Assert.isTrue((!exclusive || this.concurrentConsumers == 1 && (this.maxConcurrentConsumers == null || this.maxConcurrentConsumers == 1) ? 1 : 0) != 0, (String)"When the consumer is exclusive, the concurrency must be 1");
        super.setExclusive(exclusive);
    }

    public final void setStartConsumerMinInterval(long startConsumerMinInterval) {
        Assert.isTrue((startConsumerMinInterval > 0L ? 1 : 0) != 0, (String)"'startConsumerMinInterval' must be > 0");
        this.startConsumerMinInterval = startConsumerMinInterval;
    }

    public final void setStopConsumerMinInterval(long stopConsumerMinInterval) {
        Assert.isTrue((stopConsumerMinInterval > 0L ? 1 : 0) != 0, (String)"'stopConsumerMinInterval' must be > 0");
        this.stopConsumerMinInterval = stopConsumerMinInterval;
    }

    public final void setConsecutiveActiveTrigger(int consecutiveActiveTrigger) {
        Assert.isTrue((consecutiveActiveTrigger > 0 ? 1 : 0) != 0, (String)"'consecutiveActiveTrigger' must be > 0");
        this.consecutiveActiveTrigger = consecutiveActiveTrigger;
    }

    public final void setConsecutiveIdleTrigger(int consecutiveIdleTrigger) {
        Assert.isTrue((consecutiveIdleTrigger > 0 ? 1 : 0) != 0, (String)"'consecutiveIdleTrigger' must be > 0");
        this.consecutiveIdleTrigger = consecutiveIdleTrigger;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setBatchReceiveTimeout(long batchReceiveTimeout) {
        Assert.isTrue((batchReceiveTimeout >= 0L ? 1 : 0) != 0, (String)"'batchReceiveTimeout' must be >= 0");
        this.batchReceiveTimeout = batchReceiveTimeout;
    }

    public void setBatchSize(int batchSize) {
        Assert.isTrue((batchSize > 0 ? 1 : 0) != 0, (String)"'batchSize' must be > 0");
        this.batchSize = batchSize;
    }

    public void setConsumerBatchEnabled(boolean consumerBatchEnabled) {
        this.consumerBatchEnabled = consumerBatchEnabled;
    }

    @Override
    public boolean isConsumerBatchEnabled() {
        return this.consumerBatchEnabled;
    }

    @Override
    public void setMissingQueuesFatal(boolean missingQueuesFatal) {
        super.setMissingQueuesFatal(missingQueuesFatal);
    }

    @Override
    public void setQueueNames(String ... queueName) {
        super.setQueueNames(queueName);
        this.queuesChanged();
    }

    @Override
    public void addQueueNames(String ... queueName) {
        super.addQueueNames(queueName);
    }

    @Override
    public boolean removeQueueNames(String ... queueName) {
        if (super.removeQueueNames(queueName)) {
            this.queuesChanged();
            return true;
        }
        return false;
    }

    @Override
    public void addQueues(Queue ... queue) {
        super.addQueues(queue);
        this.queuesChanged();
    }

    @Override
    public boolean removeQueues(Queue ... queue) {
        if (super.removeQueues(queue)) {
            this.queuesChanged();
            return true;
        }
        return false;
    }

    public void setDeclarationRetries(int declarationRetries) {
        this.declarationRetries = declarationRetries;
    }

    public void setRetryDeclarationInterval(long retryDeclarationInterval) {
        this.retryDeclarationInterval = retryDeclarationInterval;
    }

    public void setConsumerStartTimeout(long consumerStartTimeout) {
        this.consumerStartTimeout = consumerStartTimeout;
    }

    public void setEnforceImmediateAckForManual(boolean enforceImmediateAckForManual) {
        this.enforceImmediateAckForManual = enforceImmediateAckForManual;
    }

    @Override
    protected void validateConfiguration() {
        super.validateConfiguration();
        Assert.state((!this.getAcknowledgeMode().isAutoAck() || this.getTransactionManager() == null ? 1 : 0) != 0, (String)"The acknowledgeMode is NONE (autoack in Rabbit terms) which is not consistent with having an external transaction manager. Either use a different AcknowledgeMode or make sure the transactionManager is null.");
    }

    protected final boolean sharedConnectionEnabled() {
        return true;
    }

    @Override
    protected void doInitialize() {
        if (this.consumerBatchEnabled) {
            this.setDeBatchingEnabled(true);
        }
    }

    @ManagedMetric(metricType=MetricType.GAUGE)
    public int getActiveConsumerCount() {
        return this.cancellationLock.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        Assert.state((!this.consumerBatchEnabled || this.getMessageListener() instanceof BatchMessageListener || this.getMessageListener() instanceof ChannelAwareBatchMessageListener ? 1 : 0) != 0, (String)"When setting 'consumerBatchEnabled' to true, the listener must support batching");
        this.checkListenerContainerAware();
        super.doStart();
        this.consumersLock.lock();
        try {
            if (this.consumers != null) {
                throw new IllegalStateException("A stopped container should not have consumers");
            }
            int newConsumers = this.initializeConsumers();
            if (this.consumers == null) {
                this.logger.info((Object)"Consumers were initialized and then cleared (presumably the container was stopped concurrently)");
                return;
            }
            if (newConsumers <= 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Consumers are already running");
                }
                return;
            }
            HashSet<AsyncMessageProcessingConsumer> processors = new HashSet<AsyncMessageProcessingConsumer>();
            for (BlockingQueueConsumer consumer : this.consumers) {
                AsyncMessageProcessingConsumer processor = new AsyncMessageProcessingConsumer(consumer);
                processors.add(processor);
                this.getTaskExecutor().execute(processor);
                if (this.getApplicationEventPublisher() == null) continue;
                this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new AsyncConsumerStartedEvent(this, consumer));
            }
            this.waitForConsumersToStart(processors);
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    private void checkListenerContainerAware() {
        ListenerContainerAware containerAware;
        Collection<String> expectedQueueNames;
        MessageListener messageListener = this.getMessageListener();
        if (messageListener instanceof ListenerContainerAware && (expectedQueueNames = (containerAware = (ListenerContainerAware)messageListener).expectedQueueNames()) != null) {
            String[] queueNames = this.getQueueNames();
            Assert.state((expectedQueueNames.size() == queueNames.length ? 1 : 0) != 0, (String)("Listener expects us to be listening on '" + String.valueOf(expectedQueueNames) + "'; our queues: " + String.valueOf(Arrays.asList(queueNames))));
            boolean found = true;
            for (String queueName : queueNames) {
                if (expectedQueueNames.contains(queueName)) continue;
                found = false;
                break;
            }
            Assert.state((boolean)found, () -> "Listener expects us to be listening on '" + String.valueOf(expectedQueueNames) + "'; our queues: " + String.valueOf(Arrays.asList(queueNames)));
        }
    }

    private void waitForConsumersToStart(Set<AsyncMessageProcessingConsumer> processors) {
        for (AsyncMessageProcessingConsumer processor : processors) {
            FatalListenerStartupException startupException = null;
            try {
                startupException = processor.getStartupException();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw RabbitExceptionTranslator.convertRabbitAccessException(e);
            }
            if (startupException == null) continue;
            throw new AmqpIllegalStateException("Fatal exception on listener startup", (Throwable)((Object)startupException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdownAndWaitOrCallback(@Nullable Runnable callback) {
        ArrayList<BlockingQueueConsumer> canceledConsumers;
        block10: {
            Thread thread = this.containerStoppingForAbort.get();
            if (thread != null && !thread.equals(Thread.currentThread())) {
                this.logger.info((Object)"Shutdown ignored - container is stopping due to an aborted consumer");
                this.runCallbackIfNotNull(callback);
                return;
            }
            canceledConsumers = new ArrayList<BlockingQueueConsumer>();
            this.consumersLock.lock();
            try {
                if (this.consumers != null) {
                    Iterator<BlockingQueueConsumer> consumerIterator = this.consumers.iterator();
                    if (this.isForceStop()) {
                        this.stopNow.set(true);
                    }
                    while (consumerIterator.hasNext()) {
                        BlockingQueueConsumer consumer = consumerIterator.next();
                        if (!this.isForceStop()) {
                            consumer.basicCancel(true);
                        }
                        canceledConsumers.add(consumer);
                        consumerIterator.remove();
                        if (!consumer.declaring) continue;
                        consumer.thread.interrupt();
                    }
                    break block10;
                }
                this.logger.info((Object)"Shutdown ignored - container is already stopped");
                this.runCallbackIfNotNull(callback);
                return;
            }
            finally {
                this.consumersLock.unlock();
            }
        }
        Runnable awaitShutdown = () -> {
            this.logger.info((Object)"Waiting for workers to finish.");
            try {
                boolean finished = this.cancellationLock.await(this.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                if (finished) {
                    this.logger.info((Object)"Successfully waited for workers to finish.");
                } else {
                    this.logger.info((Object)"Workers not finished.");
                    if (this.isForceCloseChannel() || this.stopNow.get()) {
                        canceledConsumers.forEach(consumer -> {
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn((Object)("Closing channel for unresponsive consumer: " + String.valueOf(consumer)));
                            }
                            consumer.stop();
                        });
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warn((Object)"Interrupted waiting for workers.  Continuing with shutdown.");
            }
            this.consumersLock.lock();
            try {
                this.consumers = null;
                this.cancellationLock.deactivate();
            }
            finally {
                this.consumersLock.unlock();
            }
            this.stopNow.set(false);
            this.runCallbackIfNotNull(callback);
        };
        if (callback == null) {
            awaitShutdown.run();
        } else {
            this.getTaskExecutor().execute(awaitShutdown);
        }
    }

    private void runCallbackIfNotNull(@Nullable Runnable callback) {
        if (callback != null) {
            callback.run();
        }
    }

    private boolean isActive(BlockingQueueConsumer consumer) {
        boolean consumerActive;
        this.consumersLock.lock();
        try {
            consumerActive = this.consumers != null && this.consumers.contains(consumer);
        }
        finally {
            this.consumersLock.unlock();
        }
        return consumerActive && this.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int initializeConsumers() {
        int count = 0;
        this.consumersLock.lock();
        try {
            if (this.consumers == null) {
                this.cancellationLock.reset();
                this.consumers = new HashSet<BlockingQueueConsumer>(this.concurrentConsumers);
                for (int i = 1; i <= this.concurrentConsumers; ++i) {
                    BlockingQueueConsumer consumer = this.createBlockingQueueConsumer();
                    if (this.getConsumeDelay() > 0L) {
                        consumer.setConsumeDelay(this.getConsumeDelay() * (long)i);
                    }
                    this.consumers.add(consumer);
                    ++count;
                }
            }
        }
        finally {
            this.consumersLock.unlock();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustConsumers(int deltaArg) {
        this.consumersLock.lock();
        try {
            if (this.isActive() && this.consumers != null) {
                int delta;
                if (delta > 0) {
                    Iterator<BlockingQueueConsumer> consumerIterator = this.consumers.iterator();
                    for (delta = deltaArg; consumerIterator.hasNext() && delta > 0 && (this.maxConcurrentConsumers == null || this.consumers.size() > this.maxConcurrentConsumers); --delta) {
                        BlockingQueueConsumer consumer = consumerIterator.next();
                        consumer.basicCancel(true);
                        consumerIterator.remove();
                    }
                } else {
                    this.addAndStartConsumers(-delta);
                }
            }
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAndStartConsumers(int delta) {
        block10: {
            this.consumersLock.lock();
            try {
                if (this.consumers == null) break block10;
                for (int i = 0; i < delta; ++i) {
                    if (this.maxConcurrentConsumers != null && this.consumers.size() >= this.maxConcurrentConsumers) {
                        break;
                    }
                    BlockingQueueConsumer consumer = this.createBlockingQueueConsumer();
                    this.consumers.add(consumer);
                    AsyncMessageProcessingConsumer processor = new AsyncMessageProcessingConsumer(consumer);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Starting a new consumer: " + String.valueOf(consumer)));
                    }
                    this.getTaskExecutor().execute(processor);
                    if (this.getApplicationEventPublisher() != null) {
                        this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new AsyncConsumerStartedEvent(this, consumer));
                    }
                    try {
                        FatalListenerStartupException startupException = processor.getStartupException();
                        if (startupException == null) continue;
                        this.consumers.remove(consumer);
                        throw new AmqpIllegalStateException("Fatal exception on listener startup", (Throwable)((Object)startupException));
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    catch (Exception e) {
                        consumer.stop();
                        this.logger.error((Object)"Error starting new consumer", (Throwable)e);
                        this.cancellationLock.release(consumer);
                        this.consumers.remove(consumer);
                    }
                }
            }
            finally {
                this.consumersLock.unlock();
            }
        }
    }

    private void considerAddingAConsumer() {
        this.consumersLock.lock();
        try {
            long now;
            if (this.consumers != null && this.maxConcurrentConsumers != null && this.consumers.size() < this.maxConcurrentConsumers && this.lastConsumerStarted + this.startConsumerMinInterval < (now = System.currentTimeMillis())) {
                this.addAndStartConsumers(1);
                this.lastConsumerStarted = now;
            }
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void considerStoppingAConsumer(BlockingQueueConsumer consumer) {
        this.consumersLock.lock();
        try {
            long now;
            if (this.consumers != null && this.consumers.size() > this.concurrentConsumers && this.lastConsumerStopped + this.stopConsumerMinInterval < (now = System.currentTimeMillis())) {
                consumer.basicCancel(true);
                this.consumers.remove(consumer);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Idle consumer terminating: " + String.valueOf(consumer)));
                }
                this.lastConsumerStopped = now;
            }
        }
        finally {
            this.consumersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuesChanged() {
        block7: {
            this.consumersLock.lock();
            try {
                if (this.consumers == null) break block7;
                int count = 0;
                Iterator<BlockingQueueConsumer> consumerIterator = this.consumers.iterator();
                while (consumerIterator.hasNext()) {
                    BlockingQueueConsumer consumer = consumerIterator.next();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Queues changed; stopping consumer: " + String.valueOf(consumer)));
                    }
                    consumer.basicCancel(true);
                    consumerIterator.remove();
                    ++count;
                }
                try {
                    this.cancellationLock.await(this.getShutdownTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.addAndStartConsumers(count);
            }
            finally {
                this.consumersLock.unlock();
            }
        }
    }

    protected BlockingQueueConsumer createBlockingQueueConsumer() {
        ConsumerTagStrategy consumerTagStrategy;
        String[] queues = this.getQueueNames();
        int actualPrefetchCount = this.getPrefetchCount() > this.batchSize ? this.getPrefetchCount() : this.batchSize;
        BlockingQueueConsumer consumer = new BlockingQueueConsumer(this.getConnectionFactory(), this.getMessagePropertiesConverter(), this.cancellationLock, this.getAcknowledgeMode(), this.isChannelTransacted(), actualPrefetchCount, this.isDefaultRequeueRejected(), this.getConsumerArguments(), this.isNoLocal(), this.isExclusive(), queues);
        consumer.setGlobalQos(this.isGlobalQos());
        consumer.setMissingQueuePublisher(this::publishMissingQueueEvent);
        if (this.declarationRetries != null) {
            consumer.setDeclarationRetries(this.declarationRetries);
        }
        if (this.getFailedDeclarationRetryInterval() > 0L) {
            consumer.setFailedDeclarationRetryInterval(this.getFailedDeclarationRetryInterval());
        }
        if (this.retryDeclarationInterval != null) {
            consumer.setRetryDeclarationInterval(this.retryDeclarationInterval);
        }
        if ((consumerTagStrategy = this.getConsumerTagStrategy()) != null) {
            consumer.setTagStrategy(consumerTagStrategy);
        }
        consumer.setBackOffExecution(this.getRecoveryBackOff().start());
        consumer.setShutdownTimeout(this.getShutdownTimeout());
        consumer.setApplicationEventPublisher(this.getApplicationEventPublisher());
        consumer.setMessageAckListener(this.getMessageAckListener());
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart(BlockingQueueConsumer oldConsumer) {
        block8: {
            BlockingQueueConsumer consumer = oldConsumer;
            this.consumersLock.lock();
            try {
                block9: {
                    if (this.consumers == null) break block8;
                    try {
                        consumer.stop();
                        this.cancellationLock.release(consumer);
                        this.consumers.remove(consumer);
                        if (this.isActive()) break block9;
                        return;
                    }
                    catch (RuntimeException e) {
                        this.logger.warn((Object)("Consumer failed irretrievably on restart. " + String.valueOf(e.getClass()) + ": " + e.getMessage()));
                        throw e;
                    }
                }
                BlockingQueueConsumer newConsumer = this.createBlockingQueueConsumer();
                newConsumer.setBackOffExecution(consumer.getBackOffExecution());
                consumer = newConsumer;
                this.consumers.add(consumer);
                if (this.getApplicationEventPublisher() != null) {
                    this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new AsyncConsumerRestartedEvent(this, oldConsumer, newConsumer));
                }
                this.getTaskExecutor().execute(new AsyncMessageProcessingConsumer(consumer));
            }
            finally {
                this.consumersLock.unlock();
            }
        }
    }

    private boolean receiveAndExecute(BlockingQueueConsumer consumer) throws Exception {
        PlatformTransactionManager transactionManager = this.getTransactionManager();
        if (transactionManager != null) {
            try {
                if (this.transactionTemplate == null) {
                    this.transactionTemplate = new TransactionTemplate(transactionManager, (TransactionDefinition)this.getTransactionAttribute());
                }
                boolean bl = (Boolean)this.transactionTemplate.execute(status -> {
                    RabbitResourceHolder resourceHolder = ConnectionFactoryUtils.bindResourceToTransaction(new RabbitResourceHolder(consumer.getChannel(), false), this.getConnectionFactory(), true);
                    try {
                        return this.doReceiveAndExecute(consumer);
                    }
                    catch (RuntimeException e1) {
                        this.prepareHolderForRollback(resourceHolder, e1);
                        throw e1;
                    }
                    catch (Exception e2) {
                        throw new AbstractMessageListenerContainer.WrappedTransactionException(e2);
                    }
                });
                return bl;
            }
            catch (AbstractMessageListenerContainer.WrappedTransactionException e) {
                throw (Exception)e.getCause();
            }
            finally {
                ConnectionFactoryUtils.checkAfterCompletion();
            }
        }
        return this.doReceiveAndExecute(consumer);
    }

    private boolean doReceiveAndExecute(BlockingQueueConsumer consumer) throws Exception {
        Channel channel = consumer.getChannel();
        List<Message> messages = null;
        long deliveryTag = 0L;
        boolean immediateAck = false;
        boolean isBatchReceiveTimeoutEnabled = this.batchReceiveTimeout > 0L;
        long startTime = isBatchReceiveTimeoutEnabled ? System.currentTimeMillis() : 0L;
        for (int i = 0; i < this.batchSize; ++i) {
            boolean batchTimedOut;
            boolean bl = batchTimedOut = isBatchReceiveTimeoutEnabled && System.currentTimeMillis() - startTime > this.batchReceiveTimeout;
            if (batchTimedOut) {
                if (!this.logger.isTraceEnabled()) break;
                long gathered = messages != null ? (long)messages.size() : 0L;
                this.logger.trace((Object)("Timed out for gathering batch messages. gathered size is " + gathered));
                break;
            }
            this.logger.trace((Object)"Waiting for message from consumer.");
            Message message = consumer.nextMessage(this.receiveTimeout);
            if (message == null) break;
            if (this.consumerBatchEnabled) {
                Collection<MessagePostProcessor> afterReceivePostProcessors = this.getAfterReceivePostProcessors();
                if (afterReceivePostProcessors != null) {
                    Message original = message;
                    deliveryTag = message.getMessageProperties().getDeliveryTag();
                    for (MessagePostProcessor processor : this.getAfterReceivePostProcessors()) {
                        message = processor.postProcessMessage(message);
                        if (message != null) continue;
                        if (!this.logger.isDebugEnabled()) break;
                        this.logger.debug((Object)("Message Post Processor returned 'null', discarding message " + String.valueOf(original)));
                        break;
                    }
                }
                if (message == null) continue;
                if (messages == null) {
                    messages = new ArrayList<Message>(this.batchSize);
                }
                BatchingStrategy batchingStrategy = this.getBatchingStrategy();
                if (this.isDeBatchingEnabled() && batchingStrategy.canDebatch(message.getMessageProperties())) {
                    batchingStrategy.deBatch(message, messages::add);
                    continue;
                }
                messages.add(message);
                continue;
            }
            messages = this.debatch(message);
            if (messages != null) break;
            try {
                this.executeListener(channel, message);
                continue;
            }
            catch (ImmediateAcknowledgeAmqpException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("User requested ack for failed delivery '" + e.getMessage() + "': " + message.getMessageProperties().getDeliveryTag()));
                }
                immediateAck = this.enforceImmediateAckForManual;
                break;
            }
            catch (Exception ex) {
                long tagToRollback;
                if (this.causeChainHasImmediateAcknowledgeAmqpException(ex)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("User requested ack for failed delivery: " + message.getMessageProperties().getDeliveryTag()));
                    }
                    immediateAck = this.enforceImmediateAckForManual;
                    break;
                }
                long l = tagToRollback = this.isAsyncReplies() ? message.getMessageProperties().getDeliveryTag() : -1L;
                if (this.getTransactionManager() != null) {
                    if (this.getTransactionAttribute().rollbackOn((Throwable)ex)) {
                        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory()));
                        if (resourceHolder != null) {
                            consumer.clearDeliveryTags();
                        } else {
                            consumer.rollbackOnExceptionIfNecessary(ex, tagToRollback);
                        }
                        throw ex;
                    }
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug((Object)("No rollback for " + String.valueOf(ex)));
                    break;
                }
                consumer.rollbackOnExceptionIfNecessary(ex, tagToRollback);
                throw ex;
            }
        }
        if (messages != null) {
            immediateAck = this.executeWithList(channel, messages, deliveryTag, consumer);
        }
        return consumer.commitIfNecessary(this.isChannelLocallyTransacted(), immediateAck);
    }

    private boolean executeWithList(Channel channel, List<Message> messages, long deliveryTag, BlockingQueueConsumer consumer) {
        try {
            this.executeListener(channel, messages);
        }
        catch (ImmediateAcknowledgeAmqpException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("User requested ack for failed delivery '" + e.getMessage() + "' (last in batch): " + deliveryTag));
            }
            return this.enforceImmediateAckForManual;
        }
        catch (Exception ex) {
            if (this.causeChainHasImmediateAcknowledgeAmqpException(ex)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("User requested ack for failed delivery (last in batch): " + deliveryTag));
                }
                return this.enforceImmediateAckForManual;
            }
            if (this.getTransactionManager() != null) {
                if (this.getTransactionAttribute().rollbackOn((Throwable)ex)) {
                    RabbitResourceHolder resourceHolder = (RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory()));
                    if (resourceHolder != null) {
                        consumer.clearDeliveryTags();
                    } else {
                        consumer.rollbackOnExceptionIfNecessary(ex);
                    }
                    throw ex;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No rollback for " + String.valueOf(ex)));
                }
            }
            consumer.rollbackOnExceptionIfNecessary(ex);
            throw ex;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStartupFailure(BackOffExecution backOffExecution) {
        long recoveryInterval = backOffExecution.nextBackOff();
        if (-1L == recoveryInterval) {
            this.lifecycleLock.lock();
            try {
                if (this.isActive()) {
                    this.logger.warn((Object)"stopping container - restart recovery attempts exhausted");
                    this.stop();
                }
            }
            finally {
                this.lifecycleLock.unlock();
            }
            return;
        }
        try {
            if (this.logger.isDebugEnabled() && this.isActive()) {
                this.logger.debug((Object)("Recovering consumer in " + recoveryInterval + " ms."));
            }
            long timeout = System.currentTimeMillis() + recoveryInterval;
            while (this.isActive() && System.currentTimeMillis() < timeout) {
                Thread.sleep(200L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Irrecoverable interruption on consumer restart", e);
        }
    }

    @Override
    protected void publishConsumerFailedEvent(String reason, boolean fatal, @Nullable Throwable t) {
        if (!fatal || !this.isRunning()) {
            super.publishConsumerFailedEvent(reason, fatal, t);
        } else {
            try {
                this.abortEvents.put(new ListenerContainerConsumerFailedEvent(this, reason, t, fatal));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return "SimpleMessageListenerContainer " + (String)(this.getBeanName() != null ? "(" + this.getBeanName() + ") " : "") + "[concurrentConsumers=" + this.concurrentConsumers + (String)(this.maxConcurrentConsumers != null ? ", maxConcurrentConsumers=" + this.maxConcurrentConsumers : "") + ", queueNames=" + Arrays.toString(this.getQueueNames()) + "]";
    }

    private final class AsyncMessageProcessingConsumer
    implements Runnable {
        private static final int ABORT_EVENT_WAIT_SECONDS = 5;
        private final BlockingQueueConsumer consumer;
        private final CountDownLatch start;
        private volatile FatalListenerStartupException startupException;
        private int consecutiveIdles;
        private int consecutiveMessages;
        private boolean failedExclusive;

        AsyncMessageProcessingConsumer(BlockingQueueConsumer consumer) {
            this.consumer = consumer;
            this.start = new CountDownLatch(1);
        }

        private FatalListenerStartupException getStartupException() throws InterruptedException {
            if (!this.start.await(SimpleMessageListenerContainer.this.consumerStartTimeout, TimeUnit.MILLISECONDS)) {
                SimpleMessageListenerContainer.this.logger.error((Object)("Consumer failed to start in " + SimpleMessageListenerContainer.this.consumerStartTimeout + " milliseconds; does the task executor have enough threads to support the container concurrency?"));
            }
            return this.startupException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!SimpleMessageListenerContainer.this.isActive()) {
                this.start.countDown();
                return;
            }
            boolean aborted = false;
            this.consumer.setLocallyTransacted(SimpleMessageListenerContainer.this.isChannelLocallyTransacted());
            String routingLookupKey = SimpleMessageListenerContainer.this.getRoutingLookupKey();
            if (routingLookupKey != null) {
                SimpleResourceHolder.bind(SimpleMessageListenerContainer.this.getRoutingConnectionFactory(), routingLookupKey);
            }
            if (this.consumer.getQueueCount() < 1) {
                if (SimpleMessageListenerContainer.this.logger.isDebugEnabled()) {
                    SimpleMessageListenerContainer.this.logger.debug((Object)("Consumer stopping; no queues for " + String.valueOf(this.consumer)));
                }
                SimpleMessageListenerContainer.this.cancellationLock.release(this.consumer);
                if (SimpleMessageListenerContainer.this.getApplicationEventPublisher() != null) {
                    SimpleMessageListenerContainer.this.getApplicationEventPublisher().publishEvent((ApplicationEvent)new AsyncConsumerStoppedEvent(SimpleMessageListenerContainer.this, this.consumer));
                }
                this.start.countDown();
                return;
            }
            try {
                this.initialize();
                while (SimpleMessageListenerContainer.this.isActive(this.consumer) || this.consumer.hasDelivery() || !this.consumer.cancelled()) {
                    this.mainLoop();
                }
            }
            catch (InterruptedException e) {
                SimpleMessageListenerContainer.this.logger.debug((Object)"Consumer thread interrupted, processing stopped.");
                Thread.currentThread().interrupt();
                aborted = true;
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer thread interrupted, processing stopped", true, e);
            }
            catch (QueuesNotAvailableException ex) {
                SimpleMessageListenerContainer.this.logger.error((Object)("Consumer threw missing queues exception, fatal=" + SimpleMessageListenerContainer.this.isMissingQueuesFatal()), (Throwable)((Object)ex));
                if (SimpleMessageListenerContainer.this.isMissingQueuesFatal()) {
                    this.startupException = ex;
                    aborted = true;
                }
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer queue(s) not available", aborted, (Throwable)((Object)ex));
            }
            catch (FatalListenerStartupException ex) {
                SimpleMessageListenerContainer.this.logger.error((Object)"Consumer received fatal exception on startup", (Throwable)((Object)ex));
                this.startupException = ex;
                aborted = true;
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer received fatal exception on startup", true, (Throwable)((Object)ex));
            }
            catch (FatalListenerExecutionException ex) {
                SimpleMessageListenerContainer.this.logger.error((Object)"Consumer received fatal exception during processing", (Throwable)((Object)ex));
                aborted = true;
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer received fatal exception during processing", true, (Throwable)((Object)ex));
            }
            catch (PossibleAuthenticationFailureException ex) {
                SimpleMessageListenerContainer.this.logger.error((Object)("Consumer received fatal=" + SimpleMessageListenerContainer.this.isPossibleAuthenticationFailureFatal() + " exception during processing"), (Throwable)ex);
                if (SimpleMessageListenerContainer.this.isPossibleAuthenticationFailureFatal()) {
                    this.startupException = new FatalListenerStartupException("Authentication failure", (Throwable)new AmqpAuthenticationException((Throwable)ex));
                    aborted = true;
                }
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer received PossibleAuthenticationFailure during startup", aborted, ex);
            }
            catch (ShutdownSignalException e) {
                if (RabbitUtils.isNormalShutdown(e)) {
                    if (SimpleMessageListenerContainer.this.logger.isDebugEnabled()) {
                        SimpleMessageListenerContainer.this.logger.debug((Object)("Consumer received Shutdown Signal, processing stopped: " + e.getMessage()));
                    }
                } else {
                    this.logConsumerException(e);
                }
            }
            catch (AmqpIOException e) {
                if (RabbitUtils.exclusiveAccesssRefused((Exception)((Object)e))) {
                    this.failedExclusive = true;
                    SimpleMessageListenerContainer.this.getExclusiveConsumerExceptionLogger().log(SimpleMessageListenerContainer.this.logger, "Exclusive consumer failure", e.getCause().getCause());
                    SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer raised exception, attempting restart", false, e);
                } else {
                    this.logConsumerException(e);
                }
            }
            catch (Error e) {
                SimpleMessageListenerContainer.this.logger.error((Object)"Consumer thread error, thread abort.", (Throwable)e);
                SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer threw an Error", true, e);
                SimpleMessageListenerContainer.this.getJavaLangErrorHandler().handle(e);
                aborted = true;
            }
            catch (Throwable t) {
                if (SimpleMessageListenerContainer.this.isActive()) {
                    this.logConsumerException(t);
                }
            }
            finally {
                SimpleMessageListenerContainer.this.cancellationLock.release(this.consumer);
                if (SimpleMessageListenerContainer.this.getTransactionManager() != null) {
                    ConsumerChannelRegistry.unRegisterConsumerChannel();
                }
            }
            this.start.countDown();
            this.killOrRestart(aborted);
            if (routingLookupKey != null) {
                SimpleResourceHolder.unbind(SimpleMessageListenerContainer.this.getRoutingConnectionFactory());
            }
        }

        private void mainLoop() throws Exception {
            try {
                long idleEventInterval;
                if (SimpleMessageListenerContainer.this.stopNow.get()) {
                    this.consumer.forceCloseAndClearQueue();
                    return;
                }
                boolean receivedOk = SimpleMessageListenerContainer.this.receiveAndExecute(this.consumer);
                if (SimpleMessageListenerContainer.this.maxConcurrentConsumers != null) {
                    this.checkAdjust(receivedOk);
                }
                if ((idleEventInterval = SimpleMessageListenerContainer.this.getIdleEventInterval()) > 0L) {
                    if (receivedOk) {
                        SimpleMessageListenerContainer.this.updateLastReceive();
                    } else {
                        long now = System.currentTimeMillis();
                        long lastAlertAt = SimpleMessageListenerContainer.this.lastNoMessageAlert.get();
                        long lastReceive = SimpleMessageListenerContainer.this.getLastReceive();
                        if (now > lastReceive + idleEventInterval && now > lastAlertAt + idleEventInterval && SimpleMessageListenerContainer.this.lastNoMessageAlert.compareAndSet(lastAlertAt, now)) {
                            SimpleMessageListenerContainer.this.publishIdleContainerEvent(now - lastReceive);
                        }
                    }
                }
            }
            catch (ListenerExecutionFailedException ex) {
                if (ex.getCause() instanceof NoSuchMethodException) {
                    throw new FatalListenerExecutionException("Invalid listener", (Throwable)((Object)ex));
                }
            }
            catch (AmqpRejectAndDontRequeueException amqpRejectAndDontRequeueException) {
                // empty catch block
            }
        }

        private void checkAdjust(boolean receivedOk) {
            if (receivedOk) {
                if (SimpleMessageListenerContainer.this.isActive(this.consumer)) {
                    this.consecutiveIdles = 0;
                    if (this.consecutiveMessages++ > SimpleMessageListenerContainer.this.consecutiveActiveTrigger) {
                        SimpleMessageListenerContainer.this.considerAddingAConsumer();
                        this.consecutiveMessages = 0;
                    }
                }
            } else {
                this.consecutiveMessages = 0;
                if (this.consecutiveIdles++ > SimpleMessageListenerContainer.this.consecutiveIdleTrigger) {
                    SimpleMessageListenerContainer.this.considerStoppingAConsumer(this.consumer);
                    this.consecutiveIdles = 0;
                }
            }
        }

        private void initialize() throws Throwable {
            try {
                SimpleMessageListenerContainer.this.redeclareElementsIfNecessary();
                this.consumer.start();
                this.start.countDown();
            }
            catch (QueuesNotAvailableException e) {
                if (SimpleMessageListenerContainer.this.isMissingQueuesFatal()) {
                    throw e;
                }
                this.start.countDown();
                SimpleMessageListenerContainer.this.handleStartupFailure(this.consumer.getBackOffExecution());
                throw e;
            }
            catch (FatalListenerStartupException ex) {
                if (SimpleMessageListenerContainer.this.isPossibleAuthenticationFailureFatal()) {
                    throw ex;
                }
                Throwable possibleAuthException = ex.getCause().getCause();
                if (!(possibleAuthException instanceof PossibleAuthenticationFailureException)) {
                    throw ex;
                }
                this.start.countDown();
                SimpleMessageListenerContainer.this.handleStartupFailure(this.consumer.getBackOffExecution());
                throw possibleAuthException;
            }
            catch (Throwable t) {
                this.start.countDown();
                SimpleMessageListenerContainer.this.handleStartupFailure(this.consumer.getBackOffExecution());
                throw t;
            }
            if (SimpleMessageListenerContainer.this.getTransactionManager() != null) {
                ConsumerChannelRegistry.registerConsumerChannel(this.consumer.getChannel(), SimpleMessageListenerContainer.this.getConnectionFactory());
            }
        }

        private void killOrRestart(boolean aborted) {
            if (!SimpleMessageListenerContainer.this.isActive(this.consumer) || aborted) {
                SimpleMessageListenerContainer.this.logger.debug((Object)("Cancelling " + String.valueOf(this.consumer)));
                try {
                    this.consumer.stop();
                    SimpleMessageListenerContainer.this.cancellationLock.release(this.consumer);
                    ApplicationEventPublisher applicationEventPublisher = SimpleMessageListenerContainer.this.getApplicationEventPublisher();
                    if (applicationEventPublisher != null && !SimpleMessageListenerContainer.this.isApplicationContextClosed()) {
                        applicationEventPublisher.publishEvent((ApplicationEvent)new AsyncConsumerStoppedEvent(SimpleMessageListenerContainer.this, this.consumer));
                    }
                }
                catch (AmqpException e) {
                    SimpleMessageListenerContainer.this.logger.info((Object)"Could not cancel message consumer", (Throwable)e);
                }
                if (aborted && SimpleMessageListenerContainer.this.containerStoppingForAbort.compareAndSet(null, Thread.currentThread())) {
                    SimpleMessageListenerContainer.this.logger.error((Object)"Stopping container from aborted consumer");
                    SimpleMessageListenerContainer.this.stop();
                    SimpleMessageListenerContainer.this.containerStoppingForAbort.set(null);
                    ListenerContainerConsumerFailedEvent event = null;
                    do {
                        try {
                            event = SimpleMessageListenerContainer.this.abortEvents.poll(5L, TimeUnit.SECONDS);
                            if (event == null) continue;
                            SimpleMessageListenerContainer.this.publishConsumerFailedEvent(event.getReason(), event.isFatal(), event.getThrowable());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    } while (event != null);
                }
            } else {
                LogMessage restartMessage = LogMessage.of(() -> "Restarting " + String.valueOf(this.consumer));
                if (this.failedExclusive) {
                    SimpleMessageListenerContainer.this.getExclusiveConsumerExceptionLogger().logRestart(SimpleMessageListenerContainer.this.logger, restartMessage);
                } else {
                    SimpleMessageListenerContainer.this.logger.info((Object)restartMessage);
                }
                SimpleMessageListenerContainer.this.restart(this.consumer);
            }
        }

        private void logConsumerException(Throwable t) {
            if (SimpleMessageListenerContainer.this.logger.isDebugEnabled() || !(t instanceof AmqpConnectException) && !(t instanceof ConsumerCancelledException)) {
                SimpleMessageListenerContainer.this.logger.warn((Object)"Consumer raised exception, processing can restart if the connection factory supports it", t);
            } else if (t instanceof ConsumerCancelledException && this.consumer.isNormalCancel()) {
                if (SimpleMessageListenerContainer.this.logger.isDebugEnabled()) {
                    SimpleMessageListenerContainer.this.logger.debug((Object)("Consumer raised exception, processing can restart if the connection factory supports it. Exception summary: " + String.valueOf(t)));
                }
            } else if (SimpleMessageListenerContainer.this.logger.isWarnEnabled()) {
                SimpleMessageListenerContainer.this.logger.warn((Object)("Consumer raised exception, processing can restart if the connection factory supports it. Exception summary: " + String.valueOf(t)));
            }
            SimpleMessageListenerContainer.this.publishConsumerFailedEvent("Consumer raised exception, attempting restart", false, t);
        }
    }
}

