/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.retry.support.RetryTemplate;

public class StatelessRetryOperationsInterceptorFactoryBean
extends AbstractRetryOperationsInterceptorFactoryBean {
    private static Log logger = LogFactory.getLog(StatelessRetryOperationsInterceptorFactoryBean.class);

    public RetryOperationsInterceptor getObject() {
        RetryOperationsInterceptor retryInterceptor = new RetryOperationsInterceptor();
        RetryOperations retryTemplate = this.getRetryOperations();
        if (retryTemplate == null) {
            retryTemplate = new RetryTemplate();
        }
        retryInterceptor.setRetryOperations(retryTemplate);
        MessageRecoverer messageRecoverer = this.getMessageRecoverer();
        retryInterceptor.setRecoverer((args, cause) -> {
            Message message = (Message)args[1];
            if (messageRecoverer == null) {
                logger.warn((Object)("Message dropped on recovery: " + message), cause);
            } else {
                messageRecoverer.recover(message, cause);
            }
            return null;
        });
        return retryInterceptor;
    }

    public Class<?> getObjectType() {
        return RetryOperationsInterceptor.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

