/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.Map;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractRoutingConnectionFactory
implements ConnectionFactory,
InitializingBean {
    private Map<Object, ConnectionFactory> targetConnectionFactories;
    private ConnectionFactory defaultTargetConnectionFactory;
    private boolean lenientFallback = true;

    public void setTargetConnectionFactories(Map<Object, ConnectionFactory> targetConnectionFactories) {
        Assert.notNull(targetConnectionFactories, (String)"'targetConnectionFactories' must not be null.");
        Assert.noNullElements((Object[])targetConnectionFactories.values().toArray(), (String)"'targetConnectionFactories' cannot have null values.");
        this.targetConnectionFactories = targetConnectionFactories;
    }

    public void setDefaultTargetConnectionFactory(ConnectionFactory defaultTargetConnectionFactory) {
        this.defaultTargetConnectionFactory = defaultTargetConnectionFactory;
    }

    public void setLenientFallback(boolean lenientFallback) {
        this.lenientFallback = lenientFallback;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.targetConnectionFactories, (String)"'targetConnectionFactories' must be provided.");
    }

    @Override
    public Connection createConnection() throws AmqpException {
        return this.determineTargetConnectionFactory().createConnection();
    }

    protected ConnectionFactory determineTargetConnectionFactory() {
        Object lookupKey = this.determineCurrentLookupKey();
        ConnectionFactory connectionFactory = this.targetConnectionFactories.get(lookupKey);
        if (connectionFactory == null && (this.lenientFallback || lookupKey == null)) {
            connectionFactory = this.defaultTargetConnectionFactory;
        }
        if (connectionFactory == null) {
            throw new IllegalStateException("Cannot determine target ConnectionFactory for lookup key [" + lookupKey + "]");
        }
        return connectionFactory;
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        for (ConnectionFactory connectionFactory : this.targetConnectionFactories.values()) {
            connectionFactory.addConnectionListener(listener);
        }
        if (this.defaultTargetConnectionFactory != null) {
            this.defaultTargetConnectionFactory.addConnectionListener(listener);
        }
    }

    @Override
    public boolean removeConnectionListener(ConnectionListener listener) {
        boolean removed = false;
        for (ConnectionFactory connectionFactory : this.targetConnectionFactories.values()) {
            boolean listenerRemoved = connectionFactory.removeConnectionListener(listener);
            if (removed) continue;
            removed = listenerRemoved;
        }
        if (this.defaultTargetConnectionFactory != null) {
            boolean listenerRemoved = this.defaultTargetConnectionFactory.removeConnectionListener(listener);
            if (!removed) {
                removed = listenerRemoved;
            }
        }
        return removed;
    }

    @Override
    public void clearConnectionListeners() {
        for (ConnectionFactory connectionFactory : this.targetConnectionFactories.values()) {
            connectionFactory.clearConnectionListeners();
        }
        if (this.defaultTargetConnectionFactory != null) {
            this.defaultTargetConnectionFactory.clearConnectionListeners();
        }
    }

    @Override
    public String getHost() {
        return this.determineTargetConnectionFactory().getHost();
    }

    @Override
    public int getPort() {
        return this.determineTargetConnectionFactory().getPort();
    }

    @Override
    public String getVirtualHost() {
        return this.determineTargetConnectionFactory().getVirtualHost();
    }

    protected abstract Object determineCurrentLookupKey();
}

