/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test.mockito;

import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class LambdaAnswer<T>
implements Answer<T> {
    private final boolean callRealMethod;
    private final ValueToReturn<T> callback;

    public LambdaAnswer(boolean callRealMethod, ValueToReturn<T> callback) {
        this.callRealMethod = callRealMethod;
        this.callback = callback;
    }

    public T answer(InvocationOnMock invocation) throws Throwable {
        Object result = null;
        if (this.callRealMethod) {
            result = invocation.callRealMethod();
        }
        return (T)this.callback.apply(invocation, result);
    }

    public static interface ValueToReturn<T> {
        public T apply(InvocationOnMock var1, T var2);
    }
}

