/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Type;
import org.springframework.amqp.core.Message;
import org.springframework.core.ResolvableType;
import org.springframework.data.projection.MethodInterceptorFactory;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.web.JsonProjectingMethodInterceptorFactory;
import org.springframework.util.Assert;

public class ProjectingMessageConverter {
    private final ProjectionFactory projectionFactory;

    public ProjectingMessageConverter(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"'mapper' cannot be null");
        JacksonMappingProvider provider = new JacksonMappingProvider(mapper);
        JsonProjectingMethodInterceptorFactory interceptorFactory = new JsonProjectingMethodInterceptorFactory((MappingProvider)provider);
        SpelAwareProxyProjectionFactory factory = new SpelAwareProxyProjectionFactory();
        factory.registerMethodInvokerFactory((MethodInterceptorFactory)interceptorFactory);
        this.projectionFactory = factory;
    }

    public Object convert(Message message, Type type) {
        return this.projectionFactory.createProjection(ResolvableType.forType((Type)type).resolve(Object.class), (Object)new ByteArrayInputStream(message.getBody()));
    }
}

